/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.server.service;

import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstanceKey;
import dev.compactmods.machines.api.room.upgrade.data.IRoomUpgradeDataAttachmentAccessor;
import dev.compactmods.machines.data.manager.CMKeyedDataFileManager;
import dev.compactmods.machines.room.upgrade.RoomUpgradeDataAttachments;
import dev.compactmods.machines.server.CompactMachinesServer;
import java.util.Optional;
import java.util.UUID;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class CMServerRoomUpgradeDataAccessor
implements IRoomUpgradeDataAttachmentAccessor,
AutoCloseable {
    private final CMKeyedDataFileManager<RoomUpgradeInstanceKey, RoomUpgradeDataAttachments> DATA_ATTACHMENTS = new CMKeyedDataFileManager<RoomUpgradeInstanceKey, RoomUpgradeDataAttachments>(this, CompactMachinesServer.currentServer(), RoomUpgradeDataAttachments::new){

        @Override
        public String getFileKey(RoomUpgradeInstanceKey key) {
            return key.instanceId().toString();
        }
    };

    public Optional<? extends IAttachmentHolder> get(String roomCode, UUID instanceId) {
        return this.DATA_ATTACHMENTS.optionalData(new RoomUpgradeInstanceKey(roomCode, instanceId));
    }

    public IAttachmentHolder getOrCreate(String roomCode, UUID instanceId) {
        return (IAttachmentHolder)this.DATA_ATTACHMENTS.data(new RoomUpgradeInstanceKey(roomCode, instanceId));
    }

    public void save() {
        this.DATA_ATTACHMENTS.save();
    }

    @Override
    public void close() {
        this.save();
    }
}

