/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.spatial;

import dev.compactmods.feather.MemoryGraph;
import dev.compactmods.feather.edge.GraphEdge;
import dev.compactmods.feather.node.Node;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.spatial.IRoomBoundaries;
import dev.compactmods.machines.api.room.spatial.IRoomChunkManager;
import dev.compactmods.machines.api.room.spatial.IRoomChunks;
import dev.compactmods.machines.room.graph.GraphNodes;
import dev.compactmods.machines.room.graph.edge.RoomChunkEdge;
import dev.compactmods.machines.room.graph.node.RoomChunkNode;
import dev.compactmods.machines.room.graph.node.RoomReferenceNode;
import dev.compactmods.machines.room.spatial.RoomChunks;
import dev.compactmods.machines.util.MathUtil;
import java.lang.ref.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;

public class GraphChunkManager
implements IRoomChunkManager {
    private final MemoryGraph graph = new MemoryGraph();
    private final Map<ChunkPos, RoomChunkNode> chunks = new HashMap<ChunkPos, RoomChunkNode>();

    public GraphChunkManager(MinecraftServer server) {
        CompactMachines.roomRegistrar().allRooms().forEach(inst -> this.calculateChunks(inst.code(), inst.boundaries()));
    }

    public void calculateChunks(String roomCode, IRoomBoundaries boundaries) {
        AABB outer = boundaries.outerBounds();
        Set allInside = MathUtil.getChunksFromAABB(outer).collect(Collectors.toSet());
        RoomReferenceNode ref = new RoomReferenceNode(roomCode);
        this.graph.addNode((Node)ref);
        for (ChunkPos c : allInside) {
            RoomChunkNode chunk = new RoomChunkNode(UUID.randomUUID(), new RoomChunkNode.Data(c));
            this.graph.addNode((Node)chunk);
            this.graph.connectNodes((Node)ref, (Node)chunk, (GraphEdge)new RoomChunkEdge(ref, chunk));
            this.chunks.put(c, chunk);
        }
    }

    public Optional<String> findRoomByChunk(ChunkPos chunk) {
        if (!this.chunks.containsKey(chunk)) {
            return Optional.empty();
        }
        RoomChunkNode chunkNode = this.chunks.get(chunk);
        return this.graph.inboundEdges((Node)chunkNode, RoomReferenceNode.class).map(GraphEdge::source).map(Reference::get).filter(Objects::nonNull).map(RoomReferenceNode::code).findFirst();
    }

    public IRoomChunks get(String room) {
        Optional<RoomReferenceNode> regNode = this.graph.nodes(RoomReferenceNode.class).filter(rn -> rn.code().equals(room)).findFirst();
        return regNode.map(node -> {
            Set<ChunkPos> chunks = this.graph.outboundEdges(GraphNodes.ROOM_CHUNKS, (Node)node).map(GraphEdge::target).map(Reference::get).filter(Objects::nonNull).peek(chunkNode -> this.chunks.putIfAbsent(chunkNode.data().chunk(), (RoomChunkNode)chunkNode)).map(c -> c.data().chunk()).collect(Collectors.toSet());
            return new RoomChunks(chunks);
        }).orElseThrow();
    }
}

