/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.mixin;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.slf4j.Logger;

public interface CodecNbtFunctions {
    private CompoundTag self() {
        return (CompoundTag)this;
    }

    default public <T> void store(String key, Codec<T> codec, T data) {
        this.store(key, codec, (DynamicOps<Tag>)NbtOps.INSTANCE, data);
    }

    default public <T> void storeNullable(String key, Codec<T> codec, @Nullable T data) {
        if (data != null) {
            this.store(key, codec, data);
        }
    }

    default public <T> void store(String key, Codec<T> codec, DynamicOps<Tag> ops, T data) {
        this.self().put(key, (Tag)codec.encodeStart(ops, data).getOrThrow());
    }

    default public <T> void storeNullable(String key, Codec<T> codec, DynamicOps<Tag> ops, @Nullable T data) {
        if (data != null) {
            this.store(key, codec, ops, data);
        }
    }

    default public <T> void store(MapCodec<T> codec, T data) {
        this.store(codec, (DynamicOps<Tag>)NbtOps.INSTANCE, data);
    }

    default public <T> void store(MapCodec<T> codec, DynamicOps<Tag> ops, T data) {
        this.self().merge((CompoundTag)codec.encoder().encodeStart(ops, data).getOrThrow());
    }

    default public <T> Optional<T> read(String key, Codec<T> codec) {
        return this.read(key, codec, (DynamicOps<Tag>)NbtOps.INSTANCE);
    }

    default public <T> Optional<T> read(String key, Codec<T> codec, DynamicOps<Tag> ops) {
        Tag tag = this.self().get(key);
        return tag == null ? Optional.empty() : codec.parse(ops, (Object)tag).resultOrPartial($$2x -> {
            Logger LOGGER = LogUtils.getLogger();
            LOGGER.error("Failed to read field ({}={}): {}", new Object[]{key, tag, $$2x});
        });
    }

    default public <T> Optional<T> read(MapCodec<T> codec) {
        return this.read(codec, (DynamicOps<Tag>)NbtOps.INSTANCE);
    }

    default public <T> Optional<T> read(MapCodec<T> codec, DynamicOps<Tag> ops) {
        return codec.decode(ops, (MapLike)ops.getMap((Object)this.self()).getOrThrow()).resultOrPartial(datax -> {
            Logger LOGGER = LogUtils.getLogger();
            LOGGER.error("Failed to read value ({}): {}", (Object)this, datax);
        });
    }
}

