/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.block;

import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.shrinking.PSDTags;
import dev.compactmods.machines.api.shrinking.component.ShrinkingDeviceConfiguration;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlockEntity;
import dev.compactmods.machines.machine.block.CompactMachineBlock;
import dev.compactmods.machines.network.machine.OpenMachinePreviewScreenPacket;
import dev.compactmods.machines.room.RoomBlocks;
import dev.compactmods.machines.room.RoomHelper;
import dev.compactmods.machines.shrinking.PersonalShrinkingDevice;
import dev.compactmods.machines.shrinking.Shrinking;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BoundCompactMachineBlock
extends CompactMachineBlock
implements EntityBlock {
    public BoundCompactMachineBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        try {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BoundCompactMachineBlockEntity) {
                BoundCompactMachineBlockEntity be = (BoundCompactMachineBlockEntity)blockEntity;
                ItemStack stack = Machines.Items.boundToRoom(be.connectedRoom(), (MachineColor)be.getData(CMDataAttachments.MACHINE_COLOR));
                be.getCustomName().ifPresent(cn -> stack.set(DataComponents.CUSTOM_NAME, cn));
                return stack;
            }
            return Machines.Items.unbound();
        }
        catch (Exception ex) {
            LoggingUtil.modLog().warn("Warning: tried to pick block on a bound machine that does not have a room bound.", (Throwable)ex);
            return Machines.Items.unbound();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BoundCompactMachineBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack mainItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = mainItem.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (!level.isClientSide && level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                return BoundCompactMachineBlock.tryDyingMachine(sl, pos, player, dye, mainItem);
            }
        }
        if ((mainItem.is(PSDTags.ITEM) || mainItem.has(Shrinking.DataComponents.SHRINKING_CONFIG)) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            item = level.getBlockEntity(pos);
            if (item instanceof BoundCompactMachineBlockEntity) {
                BoundCompactMachineBlockEntity tile = (BoundCompactMachineBlockEntity)item;
                RoomHelper.teleportPlayerIntoMachine(level, serverPlayer, tile.getLevelPosition(), tile.connectedRoom()).thenAccept(result -> {
                    if (result.successful()) {
                        ShrinkingDeviceConfiguration config = PersonalShrinkingDevice.config(mainItem);
                        PersonalShrinkingDevice.handleSuccessfulAtomicShift(mainItem, serverPlayer, config);
                    }
                });
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && !(player instanceof FakePlayer)) {
            level.getBlockEntity(pos, (BlockEntityType)Machines.BlockEntities.MACHINE.get()).ifPresent(machine -> {
                String roomCode = machine.connectedRoom();
                CompactMachines.room((String)roomCode).ifPresent(inst -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        sp.setData(CMDataAttachments.OPEN_MACHINE_POS, (Object)machine.getLevelPosition());
                        try {
                            StructureTemplate roomBlocks = RoomBlocks.getInternalBlocks(sp.server, inst).get();
                            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new OpenMachinePreviewScreenPacket(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos), roomCode, roomBlocks), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                });
            });
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

