/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.jade;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.compat.jade.PlayerFaceElement;
import dev.compactmods.machines.i18n.MachineTranslations;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ITextElement;

public class BoundMachineProviders {
    public static final ResourceLocation UID = CompactMachines.modRL((String)"bound_machine");
    public static final IBlockComponentProvider COMPONENT_PROVIDER = new IBlockComponentProvider(){

        public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig config) {
            Player owner;
            CompoundTag serverData = blockAccessor.getServerData();
            IElementHelper el = IElementHelper.get();
            if (serverData.contains("room_code")) {
                ITextElement boundTxt = el.text((Component)Component.literal((String)serverData.getString("room_code")).withStyle(ChatFormatting.DARK_GRAY));
                tooltip.add((IElement)boundTxt);
            }
            if (config.get(CompactMachines.modRL((String)"show_owner")) && serverData.contains("owner") && (owner = blockAccessor.getLevel().getPlayerByUUID(serverData.getUUID("owner"))) != null) {
                GameProfile ownerProfile = owner.getGameProfile();
                IElement face = new PlayerFaceElement(ownerProfile).size(new Vec2(12.0f, 12.0f)).message(null);
                ITextElement ownerName = el.text((Component)Component.translatable((String)MachineTranslations.IDs.OWNER, (Object[])new Object[]{ownerProfile.getName()}).withStyle(ChatFormatting.DARK_GRAY));
                int sizeDiffY = Mth.floor((float)(face.getSize().y - ownerName.getSize().y)) / 2;
                ownerName.translate(new Vec2(0.0f, (float)sizeDiffY));
                ITooltip ownerTT = el.tooltip();
                ownerTT.add(face);
                ownerTT.append(el.spacer(4, 0));
                ownerTT.append((IElement)ownerName);
                IBoxElement box = el.box(ownerTT, (BoxStyle)BoxStyle.getTransparent());
                tooltip.add((IElement)box);
            }
        }

        public ResourceLocation getUid() {
            return UID;
        }
    };
    public static final IServerDataProvider<BlockAccessor> SERVER_DATA = new IServerDataProvider<BlockAccessor>(){

        public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
            Player player = blockAccessor.getPlayer();
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof BoundCompactMachineBlockEntity) {
                BoundCompactMachineBlockEntity machine = (BoundCompactMachineBlockEntity)blockEntity;
                CompactMachines.room((String)machine.connectedRoom()).ifPresent(inst -> {
                    tag.store("room_code", (Codec)Codec.STRING, (Object)inst.code());
                    inst.getExistingData(CMDataAttachments.ROOM_OWNER).ifPresent(owner -> tag.store("owner", UUIDUtil.CODEC, owner));
                });
            }
        }

        public ResourceLocation getUid() {
            return UID;
        }
    };
}

