/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.rooms;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.machine.MachineConstants;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.i18n.MachineTranslations;
import dev.compactmods.machines.i18n.RoomTranslations;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlockEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CMFindRoomSubcommand {
    @NotNull
    static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder find = Commands.literal((String)"find");
        find.then(Commands.literal((String)"chunk").then(Commands.argument((String)"chunk", (ArgumentType)ColumnPosArgument.columnPos()).executes(CMFindRoomSubcommand::fetchByChunkPos)));
        find.then(Commands.literal((String)"connected_to").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(CMFindRoomSubcommand::fetchByMachineBlock)));
        find.then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(CMFindRoomSubcommand::findByContainingPlayer)));
        return find;
    }

    private static int fetchByChunkPos(CommandContext<CommandSourceStack> ctx) {
        ColumnPos chunkPos = ColumnPosArgument.getColumnPos(ctx, (String)"chunk");
        MutableComponent m = CompactMachines.chunkManager().findRoomByChunk(chunkPos.toChunkPos()).map(code -> Component.translatableWithFallback((String)"commands.cm.room_by_chunk", (String)"Room at chunk %s has ID: %s", (Object[])new Object[]{chunkPos.toString(), code})).orElse(Component.literal((String)("Room not found at chunk: " + String.valueOf(chunkPos))));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> m, false);
        return 0;
    }

    private static int fetchByMachineBlock(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos block = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        if (!level.getBlockState(block).is(MachineConstants.MACHINE_BLOCK)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure(MachineTranslations.NOT_A_MACHINE_BLOCK.apply(block));
            return -1;
        }
        BlockEntity blockEntity = level.getBlockEntity(block);
        if (blockEntity instanceof BoundCompactMachineBlockEntity) {
            BoundCompactMachineBlockEntity be = (BoundCompactMachineBlockEntity)blockEntity;
            String roomCode = be.connectedRoom();
            CompactMachines.room((String)roomCode).ifPresent(roomInfo -> ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> RoomTranslations.MACHINE_ROOM_INFO.apply(block, (RoomInstance)roomInfo), false));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Does not appear to be a bound machine block."));
        }
        return 0;
    }

    private static int findByContainingPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        if (!player.level().dimension().equals(CompactDimension.LEVEL_KEY)) {
            source.sendFailure(RoomTranslations.PLAYER_NOT_IN_COMPACT_DIM.apply((Player)player));
            return -1;
        }
        Component m = CompactMachines.chunkManager().findRoomByChunk(player.chunkPosition()).map(code -> (Component)RoomTranslations.PLAYER_ROOM_INFO.apply((Player)player, code)).orElse(RoomTranslations.UNKNOWN_ROOM_BY_PLAYER_CHUNK.apply((Player)player));
        source.sendSuccess(() -> m, false);
        return 0;
    }

    public static int findByOwner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer owner = EntityArgument.getPlayer(ctx, (String)"owner");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        return 0;
    }
}

