/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.i18n.MachineTranslations;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlockEntity;
import dev.compactmods.machines.machine.block.UnboundCompactMachineBlock;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CMUnbindSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.literal((String)"unbind").requires(cs -> cs.hasPermission(2));
        subRoot.then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(CMUnbindSubcommand::doUnbind));
        return subRoot;
    }

    private static int doUnbind(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        ServerLevel compactDim = server.getLevel(CompactDimension.LEVEL_KEY);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (compactDim == null) {
            return -1;
        }
        BlockPos rebindingMachine = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos");
        BlockEntity blockEntity = level.getBlockEntity(rebindingMachine);
        if (!(blockEntity instanceof BoundCompactMachineBlockEntity)) {
            LoggingUtil.modLog().error("Refusing to rebind block at {}; block has invalid machine data.", (Object)rebindingMachine);
            source.sendFailure(MachineTranslations.NOT_A_MACHINE_BLOCK.apply(rebindingMachine));
            return -1;
        }
        BoundCompactMachineBlockEntity machine = (BoundCompactMachineBlockEntity)blockEntity;
        level.setBlock(rebindingMachine, ((UnboundCompactMachineBlock)((Object)Machines.Blocks.UNBOUND_MACHINE.get())).defaultBlockState(), 3);
        return 0;
    }
}

