/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.widget;

import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ImageButtonBuilder {
    private int x = 0;
    private int y = 0;
    private int width = 18;
    private int height = 18;
    private Component message = CommonComponents.EMPTY;
    private Button.OnPress onPress;
    private final WidgetSprites sprites;

    private ImageButtonBuilder(WidgetSprites sprites) {
        this.sprites = sprites;
    }

    public static ImageButtonBuilder button(WidgetSprites sprites) {
        return new ImageButtonBuilder(sprites);
    }

    public ImageButtonBuilder location(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ImageButtonBuilder size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public ImageButtonBuilder message(Component message) {
        this.message = message;
        return this;
    }

    public ImageButtonBuilder onPress(Button.OnPress handler) {
        this.onPress = handler;
        return this;
    }

    public ImageButton build() {
        return new ImageButton(this.x, this.y, this.width, this.height, this.sprites, this.onPress, this.message);
    }
}

