/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.BlockEntityCustomItemRenderer;
import com.supermartijn642.core.render.CustomRendererBakedModelWrapper;
import com.supermartijn642.wirelesschargers.ChargerModelType;
import com.supermartijn642.wirelesschargers.ChargerRenderer;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.screen.ChargerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WirelessChargersClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"wirelesschargers");
        for (ChargerType chargerType : ChargerType.values()) {
            handler.registerCustomBlockEntityRenderer(chargerType::getBlockEntityType, ChargerRenderer::new);
            ModelResourceLocation location = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"wirelesschargers", (String)chargerType.getRegistryName()), "inventory");
            handler.registerModelOverwrite(location, CustomRendererBakedModelWrapper::wrap);
            handler.registerCustomItemRenderer(chargerType::getItem, () -> new BlockEntityCustomItemRenderer(true, () -> type.createBlockEntity(BlockPos.ZERO, type.getBlock().defaultBlockState()), (stack, entity) -> entity.readData(stack.has(BaseBlock.TILE_DATA) ? (CompoundTag)stack.get(BaseBlock.TILE_DATA) : new CompoundTag())));
        }
        for (ChargerModelType chargerModelType : ChargerModelType.values()) {
            handler.registerModel(chargerModelType.ringModel);
        }
    }

    public static void openChargerScreen(Component title, Level level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChargerScreen(title, level, pos)));
    }
}

