/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.common.util.InventoryUpdateListener;
import es.degrassi.mmreborn.common.util.ItemSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class IOInventory
implements IItemHandlerModifiable,
Container,
ISyncableStuff {
    private final List<ItemSlot> inputs = new ArrayList<ItemSlot>();
    private final List<ItemSlot> outputs = new ArrayList<ItemSlot>();
    private final Map<Integer, Integer> slotLimits = Maps.newHashMap();
    private final List<ItemSlot> inventory = Lists.newArrayList();
    private int[] inSlots = new int[0];
    private int[] outSlots = new int[0];
    private int[] miscSlots = new int[0];
    private IOInventoryChangedListener listener = null;
    public List<Direction> accessibleSides = new ArrayList<Direction>();

    private IOInventory() {
        this.accessibleSides = Arrays.asList(Direction.values());
    }

    public IOInventory(int[] inSlots, int[] outSlots) {
        this(inSlots, outSlots, Direction.values());
    }

    public IOInventory(int[] inSlots, int[] outSlots, Direction ... accessibleFrom) {
        this.inSlots = inSlots;
        this.outSlots = outSlots;
        this.inventory.addAll(this.generateInventory());
        this.accessibleSides = Arrays.asList(accessibleFrom);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.inventory.forEach(component -> component.getStuffToSync(container));
    }

    public List<ItemStack> getAllInputStacks() {
        return this.inputs.stream().map(slot -> slot.getStackInSlot(0)).toList();
    }

    public List<ItemStack> getAllOutputStacks() {
        return this.outputs.stream().map(slot -> slot.getStackInSlot(0)).toList();
    }

    public List<ItemStack> getAllStacks() {
        return this.inventory.stream().map(slot -> slot.getStackInSlot(0)).toList();
    }

    public IOInventory setMiscSlots(int ... miscSlots) {
        this.miscSlots = miscSlots;
        int[] nArray = miscSlots;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer slot = nArray[i];
            this.inventory.add(new ItemSlot(slot, this, 64, 64, 0, item -> true));
        }
        return this;
    }

    public IOInventory setStackLimit(int limit, int ... slots) {
        for (int slot : slots) {
            this.slotLimits.put(slot, limit);
        }
        return this;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventory.stream().filter(s -> s.getSlot() == slot).findFirst().ifPresent(s -> {
            s.setItemStack(stack);
            this.setChanged();
        });
    }

    public int getSlots() {
        return this.inventory.size();
    }

    public int getSlotLimit(int slot) {
        if (this.slotLimits.containsKey(slot)) {
            return this.slotLimits.get(slot);
        }
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inventory.stream().filter(s -> s.getSlot() == slot).findFirst().map(s -> s.isItemValid(0, stack)).orElse(false);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return Optional.ofNullable(this.inventory.get(slot)).map(ItemSlot::getItemStack).orElse(ItemStack.EMPTY);
    }

    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        ItemStack toInsert = stack.copy();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!(toInsert = this.insertItem(i, toInsert.copy(), simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return toInsert;
    }

    public ItemStack extractItem(@Nonnull ItemStack stack, boolean simulate) {
        int toExtract = stack.getCount();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getItem(i).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)this.getItem(i), (ItemStack)stack) || (toExtract -= this.extractItem(i, toExtract, simulate).getCount()) > 0) continue;
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(toExtract);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.inventory.get(slot).insertItem(0, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.inventory.get(slot).extractItem(0, amount, simulate);
    }

    public int getContainerSize() {
        return this.getSlots();
    }

    public ItemStack getItem(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.extractItem(slot, amount, false);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack prevStack = this.getStackInSlot(slot);
        this.setStackInSlot(slot, ItemStack.EMPTY);
        return prevStack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.setStackInSlot(slot, stack);
    }

    public void setChanged() {
        if (this.listener != null) {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                this.listener.onChange(i, this.getItem(i));
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int j = 0; j < this.getContainerSize(); ++j) {
            this.removeItemNoUpdate(j);
        }
    }

    public boolean isEmpty() {
        return this.inventory.stream().map(ItemSlot::getItemStack).allMatch(ItemStack::isEmpty);
    }

    public CompoundTag writeNBT(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.putIntArray("inSlots", this.inSlots);
        tag.putIntArray("outSlots", this.outSlots);
        tag.putIntArray("miscSlots", this.miscSlots);
        ListTag components = new ListTag();
        this.inventory.forEach(value -> components.add((Object)value.serializeNBT(pRegistries)));
        tag.put("items", (Tag)components);
        return tag;
    }

    public void readNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.inSlots = tag.getIntArray("inSlots");
        this.outSlots = tag.getIntArray("outSlots");
        this.miscSlots = tag.getIntArray("miscSlots");
        if (tag.contains("items")) {
            ListTag components = tag.getList("items", 10);
            components.stream().filter(t -> t instanceof CompoundTag).map(t -> (CompoundTag)t).forEach(componentNBT -> {
                if (componentNBT.contains("slot")) {
                    this.inventory.stream().filter(inv -> inv.getSlot() == componentNBT.getInt("slot")).findFirst().ifPresentOrElse(inv -> inv.deserialize(pRegistries, (CompoundTag)componentNBT), () -> this.inventory.add(new ItemSlot(this, item -> true, (CompoundTag)componentNBT, pRegistries)));
                }
            });
            this.setChanged();
        }
    }

    private List<ItemSlot> generateInventory() {
        ItemSlot itemSlot;
        Integer slot;
        int n;
        ArrayList<ItemSlot> inventory = new ArrayList<ItemSlot>();
        int[] nArray = this.inSlots;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            slot = nArray[n];
            itemSlot = new ItemSlot(slot, this, this.getSlotLimit(slot), this.getSlotLimit(slot), 0, item -> true);
            this.inputs.add(itemSlot);
            inventory.add(itemSlot);
        }
        nArray = this.outSlots;
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            slot = nArray[n];
            itemSlot = new ItemSlot(slot, this, this.getSlotLimit(slot), 0, this.getSlotLimit(slot), item -> true);
            this.outputs.add(itemSlot);
            inventory.add(itemSlot);
        }
        return inventory;
    }

    public void deserialize(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNBT(tag, pRegistries);
    }

    public int calcRedstoneFromInventory() {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.getSlots(); ++j) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(this.getSlotLimit(j), itemstack.getMaxStackSize());
            ++i;
        }
        return Mth.floor((float)((f /= (float)this.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static IOInventory mergeBuild(IOInventory ... inventories) {
        IOInventory merged = new IOInventory();
        int slotOffset = 0;
        HashMap slotLimitIndex = Maps.newHashMap();
        ArrayList inSlots = Lists.newArrayList();
        ArrayList outSlots = Lists.newArrayList();
        ArrayList miscSlots = Lists.newArrayList();
        List<Object> sides = Lists.newArrayList((Object[])Direction.values());
        ArrayList inputs = Lists.newArrayList();
        ArrayList outputs = Lists.newArrayList();
        for (IOInventory inventory : inventories) {
            for (ItemSlot itemSlot : inventory.inventory) {
                merged.inventory.add(itemSlot.getSlot() + slotOffset, itemSlot);
            }
            for (Integer n : inventory.slotLimits.keySet()) {
                merged.slotLimits.put(n + slotOffset, inventory.slotLimits.get(n));
            }
            int finalSlotOffset = slotOffset;
            Arrays.stream(inventory.inSlots).map(in -> in + finalSlotOffset).forEach(inSlots::add);
            Arrays.stream(inventory.outSlots).map(out -> out + finalSlotOffset).forEach(outSlots::add);
            Arrays.stream(inventory.miscSlots).map(misc -> misc + finalSlotOffset).forEach(miscSlots::add);
            sides = sides.stream().map(side -> {
                if (inventory.accessibleSides.contains(side)) {
                    return side;
                }
                return null;
            }).filter(Objects::nonNull).toList();
            slotLimitIndex.put(slotOffset += inventory.inventory.size(), inventory);
            inputs.addAll(inventory.inputs);
            outputs.addAll(inventory.outputs);
        }
        merged.accessibleSides = sides;
        merged.inSlots = inSlots.stream().mapToInt(i -> i).toArray();
        merged.outSlots = outSlots.stream().mapToInt(i -> i).toArray();
        merged.miscSlots = miscSlots.stream().mapToInt(i -> i).toArray();
        merged.inputs.addAll(inputs);
        merged.outputs.addAll(outputs);
        merged.setListener((slot, stack) -> slotLimitIndex.forEach((slotLimit, inventory) -> {
            if (slotLimit < slot) {
                inventory.listener.onChange(slot - slotLimit, stack);
            }
        }));
        return merged;
    }

    public List<Slot> createInventorySlots(List<Slot> slots, int i) {
        for (int j = 0; j < this.getSlots(); ++j) {
            slots.add(this.createSlot(j, i));
        }
        return slots;
    }

    public List<Slot> createSlots(Player player) {
        int i;
        ArrayList slots = Lists.newArrayList();
        for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
            slots.add(new Slot((Container)player.getInventory(), i, 0, 0));
        }
        return this.createInventorySlots(slots, i);
    }

    private Slot createSlot(int i, int increment) {
        return new Slot((Container)this, i + increment, 0, 0);
    }

    public void removeFromInputs(ItemStack stack, int amount) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemSlot> slotPredicate = component -> true;
        this.inputs.stream().filter(component -> ItemStack.isSameItemSameComponents((ItemStack)component.getItemStack(), (ItemStack)stack) && slotPredicate.test((ItemSlot)component)).forEach(component -> {
            int maxExtract = Math.min(component.getItemStack().getCount(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.getItemStack().shrink(maxExtract);
        });
        this.setChanged();
    }

    public void addToOutputs(ItemStack stack, int amount) {
        AtomicInteger toAdd = new AtomicInteger(amount);
        this.outputs.stream().filter(component -> this.canPlaceOutput((ItemSlot)component, stack)).forEach(component -> {
            int maxInsert = toAdd.get() - component.insertItemBypassLimit(stack, true).getCount();
            toAdd.addAndGet(-maxInsert);
            component.insertItemBypassLimit(stack.copyWithCount(maxInsert), false);
        });
        this.setChanged();
    }

    public boolean canPlaceOutput(@NotNull ItemSlot component, ItemStack stack) {
        if (!component.isItemValid(0, stack)) {
            return false;
        }
        if (component.getItemStack().isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)component.getItemStack(), (ItemStack)stack)) {
            return false;
        }
        return component.getItemStack().getCount() < Math.min(stack.getMaxStackSize(), component.getCapacity());
    }

    public int getSpaceForItem(ItemStack stack) {
        return this.outputs.stream().filter(component -> this.canPlaceOutput((ItemSlot)component, stack)).mapToInt(component -> {
            if (component.getItemStack().isEmpty()) {
                return Math.min(component.getCapacity(), stack.getMaxStackSize());
            }
            return Math.min(component.getCapacity() - component.getItemStack().getCount(), stack.getMaxStackSize() - component.getItemStack().getCount());
        }).sum();
    }

    public int getItemAmount(ItemStack stack) {
        Predicate<ItemSlot> slotPredicate = component -> true;
        return this.inputs.stream().filter(component -> ItemStack.isSameItemSameComponents((ItemStack)component.getItemStack(), (ItemStack)stack) && slotPredicate.test((ItemSlot)component)).mapToInt(component -> component.getItemStack().getCount()).sum();
    }

    @Generated
    public List<ItemSlot> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<ItemSlot> getOutputs() {
        return this.outputs;
    }

    @Generated
    public List<ItemSlot> getInventory() {
        return this.inventory;
    }

    @Generated
    public void setListener(IOInventoryChangedListener listener) {
        this.listener = listener;
    }

    public static interface IOInventoryChangedListener
    extends InventoryUpdateListener {
        public void onChange(int var1, ItemStack var2);

        @Override
        default public void onChange() {
        }
    }
}

