/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public abstract class CustomJsonReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Gson GSON = new GsonBuilder().create();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private static final Logger LOGGER = MMRLogger.INSTANCE;
    private final String directory;

    public CustomJsonReloadListener(String string) {
        this.directory = string;
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager manager, ProfilerFiller profiler) {
        LOGGER.info("Parsing all .json files in {} folder.", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (Map.Entry entry : manager.listResources(this.directory, loc -> loc.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation loc2 = (ResourceLocation)entry.getKey();
            String path = loc2.getPath();
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)loc2.getNamespace(), (String)path.substring(i, path.length() - PATH_SUFFIX_LENGTH));
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.fromNullableJson((Gson)GSON, (Reader)reader, JsonElement.class, (boolean)false);
                    if (jsonElement != null) {
                        JsonElement replaced = map.put(id, jsonElement);
                        if (replaced == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                    }
                    LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)loc2);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error("Couldn't parse data file {} from {}\n{}", (Object)id, (Object)loc2, (Object)e);
            }
        }
        LOGGER.info("Finished, {} .json files successfully parsed in {} folder.", (Object)map.size(), (Object)this.directory);
        return map;
    }
}

