/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager.crafting;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.crafting.CraftingContext;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessorCore;
import es.degrassi.mmreborn.common.manager.crafting.RecipeChecker;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class MachineRecipeFinder {
    private final MachineControllerEntity tile;
    private final int baseCooldown;
    private final CraftingContext.Mutable mutableCraftingContext;
    private List<RecipeChecker<MachineRecipe>> recipes;
    private List<RecipeChecker<MachineRecipe>> okToCheck;
    private boolean componentChanged = true;
    private int recipeCheckCooldown;
    private final MachineProcessorCore core;

    public MachineRecipeFinder(MachineControllerEntity tile, CraftingContext.Mutable mutableCraftingContext, MachineProcessorCore core) {
        this.tile = tile;
        this.baseCooldown = (Integer)MMRConfig.get().checkRecipeTicks.get();
        this.mutableCraftingContext = mutableCraftingContext;
        this.core = core;
    }

    public void init() {
        if (this.tile.getLevel() == null) {
            throw new IllegalStateException("Broken machine " + String.valueOf(this.tile.getFoundMachine().getRegistryName()) + "doesn't have a world");
        }
        this.recipes = this.tile.getLevel().getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistration.RECIPE_TYPE.get()).stream().filter(recipe -> ((MachineRecipe)recipe.value()).getOwningMachineIdentifier().equals((Object)this.tile.getId())).sorted(Comparator.comparing(RecipeHolder::value)).map(RecipeChecker::new).toList().reversed();
        this.okToCheck = Lists.newArrayList();
        this.recipeCheckCooldown = this.tile.getLevel().random.nextInt(this.baseCooldown);
    }

    public Optional<RecipeHolder<MachineRecipe>> findRecipe(boolean immediately) {
        if (this.tile.getLevel() == null) {
            return Optional.empty();
        }
        if (!this.core.isActive()) {
            return Optional.empty();
        }
        if (immediately || this.recipeCheckCooldown-- <= 0) {
            this.recipeCheckCooldown = this.baseCooldown;
            if (this.componentChanged || immediately) {
                this.okToCheck.clear();
                this.okToCheck.addAll(this.recipes);
            }
            Iterator<RecipeChecker<MachineRecipe>> iterator = this.okToCheck.iterator();
            while (iterator.hasNext()) {
                RecipeChecker<MachineRecipe> checker = iterator.next();
                if (!this.componentChanged && checker.isInventoryRequirementsOnly() && !immediately) continue;
                if (checker.check(this.tile, this.mutableCraftingContext.setRecipe((MachineRecipe)checker.getRecipe().value(), checker.getRecipe().id()), this.componentChanged || immediately)) {
                    this.setComponentChanged(false);
                    return Optional.of(checker.getRecipe());
                }
                if (checker.isInventoryRequirementsOk()) continue;
                iterator.remove();
            }
            this.setComponentChanged(false);
        }
        return Optional.empty();
    }

    @Generated
    public void setComponentChanged(boolean componentChanged) {
        this.componentChanged = componentChanged;
    }
}

