/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.entity.ItemInputBusEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.network.server.component.SUpdateItemComponentPacket;
import es.degrassi.mmreborn.common.util.IOInventory;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class TileItemBus
extends TileInventory
implements MachineComponentEntity<ItemComponent>,
ControllerAccessible {
    private BlockPos controllerPos;
    private ItemBusSize size;
    private IOType ioType;

    public TileItemBus(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState, ItemBusSize size, IOType ioType) {
        super(entityType, pos, blockState, size.getSlotCount());
        this.size = size;
        this.ioType = ioType;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                Level level;
                if (TileItemBus.this.getController() != null) {
                    TileItemBus.this.getController().getProcessor().setMachineInventoryChanged();
                }
                if ((level = TileItemBus.this.getLevel()) instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(TileItemBus.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, TileItemBus.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < TileItemBus.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, TileItemBus.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    @Nullable
    public ItemComponent provideComponent() {
        return new ItemComponent(this.getInventory(), this.ioType);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ItemBusSize.value(compound.getString("busSize"));
        this.ioType = IOType.getByString(compound.getString("ioType"));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                Level level;
                if (TileItemBus.this.getController() != null) {
                    TileItemBus.this.getController().getProcessor().setMachineInventoryChanged();
                }
                if ((level = TileItemBus.this.getLevel()) instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(TileItemBus.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, TileItemBus.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < TileItemBus.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, TileItemBus.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.ioType == null) {
            this.ioType = this instanceof ItemInputBusEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ItemBusSize getSize() {
        return this.size;
    }

    @Generated
    public IOType getIoType() {
        return this.ioType;
    }
}

