/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ComponentMapper;
import es.degrassi.mmreborn.api.crafting.ComponentNotFoundException;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.IntegerSyncable;
import es.degrassi.mmreborn.api.network.syncable.NbtSyncable;
import es.degrassi.mmreborn.api.network.syncable.StringSyncable;
import es.degrassi.mmreborn.client.model.ControllerBakedModel;
import es.degrassi.mmreborn.common.crafting.helper.CraftingStatus;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.base.BlockEntityRestrictedTick;
import es.degrassi.mmreborn.common.entity.base.BlockEntitySynchronized;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.machine.Sounds;
import es.degrassi.mmreborn.common.manager.ComponentManager;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessor;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.network.server.SMachineUpdatePacket;
import es.degrassi.mmreborn.common.network.server.SSyncPauseStatePacket;
import es.degrassi.mmreborn.common.network.server.SUpdateCraftingStatusPacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import es.degrassi.mmreborn.common.util.SoundManager;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MachineControllerEntity
extends BlockEntityRestrictedTick
implements ComponentMapper,
ISyncableStuff {
    private CraftingStatus craftingStatus = CraftingStatus.MISSING_STRUCTURE;
    private boolean isPaused = false;
    private ResourceLocation id = DynamicMachine.DUMMY.getRegistryName();
    private MachineStatus status = MachineStatus.IDLE;
    private Component errorMessage = Component.empty();
    private final ComponentManager componentManager;
    private final MachineProcessor processor;
    private int lastFocus;
    private SoundManager soundManager;
    private final long tickOffset = Utils.RAND.nextLong(0L, Long.MAX_VALUE);
    private long lastCheckTick;

    public MachineControllerEntity(BlockPos pos, BlockState state) {
        super(EntityRegistration.CONTROLLER.get(), pos, state);
        this.componentManager = new ComponentManager(this);
        this.processor = new MachineProcessor(this);
    }

    public void setStatus(MachineStatus status, Component message) {
        if (this.status != status) {
            this.componentManager.getFoundComponentsList().forEach(component -> component.onStatusChanged(this.status, status, message));
            this.status = status;
            this.errorMessage = message;
            this.setCraftingStatus(this.craftingByMachine(status));
            this.setRequestModelUpdate(true);
            this.setChanged();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                BlockPos pos = this.getBlockPos();
                level2.updateNeighborsAt(pos, this.getBlockState().getBlock());
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SUpdateCraftingStatusPacket(this.status, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    private CraftingStatus craftingByMachine(MachineStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case MachineStatus.IDLE -> CraftingStatus.NO_RECIPE;
            case MachineStatus.PAUSED -> this.craftingStatus;
            case MachineStatus.ERRORED -> CraftingStatus.failure(this.errorMessage);
            case MachineStatus.RUNNING -> CraftingStatus.working();
            case MachineStatus.MISSING_STRUCTURE -> CraftingStatus.MISSING_STRUCTURE;
        };
    }

    public void setStatus(MachineStatus status) {
        this.setStatus(status, (Component)Component.empty());
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ControllerBakedModel.MACHINE, (Object)this.getFoundMachine()).build();
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pause() {
        this.setPaused(RedstoneHelper.getReceivingRedstone(this) > 0);
    }

    public void setPaused(boolean paused) {
        this.isPaused = paused;
        if (paused) {
            this.setStatus(MachineStatus.PAUSED);
        }
        if (!this.getLevel().isClientSide) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.getLevel()), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SSyncPauseStatePacket(this.isPaused, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void doClientTick() {
        SoundEvent sound;
        if (this.soundManager == null) {
            this.soundManager = new SoundManager(this.getBlockPos());
        }
        if ((sound = this.getFoundMachine().getAmbientSound(this.status)) != null && !sound.getLocation().equals((Object)this.soundManager.getSoundID())) {
            if (this.getFoundMachine().getAmbientSound(this.status) == Sounds.DEFAULT.ambientSound()) {
                this.soundManager.setSound(null);
            } else {
                this.soundManager.setSound(this.getFoundMachine().getAmbientSound(this.status));
            }
        } else {
            this.soundManager.setSound(null);
        }
        if (!this.soundManager.isPlaying()) {
            this.soundManager.play();
        }
    }

    @Override
    public void doRestrictedTick() {
        this.pause();
        this.checkStructure(false);
        if (this.status.isMissingStructure()) {
            this.processor.reset();
            this.componentManager.reset();
            return;
        }
        this.componentManager.updateComponents(false);
        if (this.isPaused()) {
            return;
        }
        try {
            this.processor.tick();
        }
        catch (ComponentNotFoundException e) {
            ModularMachineryReborn.LOGGER.error(e.getMessage());
        }
    }

    public void setRemoved() {
        if (this.level != null && this.level.isClientSide() && this.soundManager != null) {
            this.soundManager.stop();
        }
        super.setRemoved();
    }

    public void setMachine(ResourceLocation machine) {
        this.id = machine;
        this.distributeCasingColor(false, this.getBlockPos());
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SMachineUpdatePacket(this.id, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setRequestModelUpdate(true);
        this.refreshClientData();
        this.setChanged();
    }

    public void checkStructure(boolean immediate) {
        if (this.getFoundMachine() == DynamicMachine.DUMMY) {
            return;
        }
        long gameTime = this.getLevel().getGameTime();
        if (!Utils.shouldRunPeriodicCheck(immediate, gameTime, this.lastCheckTick, this.tickOffset, ((Integer)MMRConfig.get().checkStructureTicks.get()).intValue())) {
            return;
        }
        this.lastCheckTick = gameTime;
        if (!this.getFoundMachine().getPattern().match((LevelReader)this.getLevel(), this.getBlockPos(), (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) {
            this.distributeCasingColor(true);
            this.setStatus(MachineStatus.MISSING_STRUCTURE);
        } else {
            this.distributeCasingColor(false);
            this.componentManager.updateComponents(false);
            if (!this.status.isCrafting()) {
                this.setStatus(MachineStatus.IDLE);
            } else {
                this.setStatus(this.status);
            }
        }
        this.setRequestModelUpdate(true);
        this.setChanged();
    }

    public void distributeCasingColor(boolean default_, BlockPos ... poss) {
        int color = default_ ? Config.machineColor : this.getFoundMachine().getMachineColor();
        for (BlockPos pos : poss) {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(pos);
            if (blockEntity instanceof MachineControllerEntity) {
                MachineControllerEntity entity = (MachineControllerEntity)blockEntity;
                this.tryColorize(pos, entity.getFoundMachine().getMachineColor());
                continue;
            }
            this.tryColorize(this.getBlockPos().offset((Vec3i)pos), color);
        }
        this.tryColorize(this.getBlockPos(), this.getFoundMachine().getMachineColor());
    }

    public void distributeCasingColor(boolean default_) {
        if (ModularMachineryReborn.MACHINES.get((Object)this.id) != DynamicMachine.DUMMY) {
            this.distributeCasingColor(default_, (BlockPos[])this.getFoundMachine().getPattern().getBlocks((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).keySet().toArray(BlockPos[]::new));
        } else if (!this.getFoundMachine().getPattern().match((LevelReader)this.getLevel(), this.getBlockPos(), (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) {
            BlockPos[] blockPos = (BlockPos[])this.getFoundMachine().getPattern().getBlocks((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).keySet().toArray(BlockPos[]::new);
            this.distributeCasingColor(true, blockPos);
            for (BlockPos pos : blockPos) {
                BlockEntity blockEntity = this.getLevel().getBlockEntity(this.getBlockPos().offset((Vec3i)pos));
                if (!(blockEntity instanceof BlockEntitySynchronized)) continue;
                BlockEntitySynchronized entity = (BlockEntitySynchronized)blockEntity;
                entity.setInStructure(false);
                entity.setChanged();
            }
        }
    }

    private void tryColorize(BlockPos pos, int color) {
        BlockEntity te = this.getLevel().getBlockEntity(pos);
        if (te instanceof ColorableMachineEntity) {
            ColorableMachineEntity entity = (ColorableMachineEntity)te;
            entity.setMachineColor(color);
            te.setChanged();
        }
    }

    public DynamicMachine getFoundMachine() {
        return (DynamicMachine)ModularMachineryReborn.MACHINES.getOrDefault((Object)this.id, (Object)DynamicMachine.DUMMY);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.craftingStatus = CraftingStatus.deserialize(compound.getCompound("status"), pRegistries);
        this.id = ResourceLocation.parse((String)compound.getString("machine"));
        this.processor.deserialize(compound.getCompound("craftingManager"));
        if (this.getLevel() != null && !this.getLevel().isClientSide) {
            this.checkStructure(true);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("status", (Tag)this.craftingStatus.serializeNBT(pRegistries));
        compound.putString("machine", this.id.toString());
        compound.put("craftingManager", (Tag)this.processor.serialize());
        compound.put("componentManager", (Tag)this.componentManager.serializeNBT(pRegistries));
    }

    public void refreshClientData() {
        this.requestModelDataUpdate();
    }

    public List<MachineComponent<?>> getFoundComponents() {
        return this.componentManager.getFoundComponentsList();
    }

    @Override
    public Map<BlockPos, MachineComponent<?>> getFoundComponentsMap() {
        return this.componentManager.getFoundComponentsMap();
    }

    public List<ModifierReplacement> getFoundModifiers() {
        return this.componentManager.getFoundModifiersList();
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        if (this.getLevel() == null) {
            return;
        }
        this.processor.getStuffToSync(container);
        this.componentManager.getStuffToSync(container);
        RegistryAccess registries = this.getLevel().registryAccess();
        container.accept(StringSyncable.create(() -> this.id.toString(), s -> {
            this.id = ResourceLocation.parse((String)s);
        }));
        container.accept(IntegerSyncable.create(() -> this.lastFocus, i -> {
            this.lastFocus = i;
        }));
        container.accept(NbtSyncable.create(() -> this.craftingStatus.serializeNBT((HolderLookup.Provider)this.getLevel().registryAccess()), s -> {
            this.craftingStatus = CraftingStatus.deserialize(s, (HolderLookup.Provider)this.getLevel().registryAccess());
        }));
        container.accept(StringSyncable.create(() -> this.status.toString(), status -> {
            this.status = MachineStatus.value(status);
        }));
        container.accept(StringSyncable.create(() -> Component.Serializer.toJson((Component)this.errorMessage, (HolderLookup.Provider)registries), errorMessage -> {
            this.errorMessage = Component.Serializer.fromJson((String)errorMessage, (HolderLookup.Provider)registries);
        }));
    }

    public SoundType getInteractionSound() {
        return this.getFoundMachine().getInteractionSound(this.status);
    }

    @Generated
    public CraftingStatus getCraftingStatus() {
        return this.craftingStatus;
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public MachineStatus getStatus() {
        return this.status;
    }

    @Generated
    public Component getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Generated
    public MachineProcessor getProcessor() {
        return this.processor;
    }

    @Generated
    public int getLastFocus() {
        return this.lastFocus;
    }

    @Generated
    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    @Generated
    public long getTickOffset() {
        return this.tickOffset;
    }

    @Generated
    public long getLastCheckTick() {
        return this.lastCheckTick;
    }

    @Generated
    public void setId(ResourceLocation id) {
        this.id = id;
    }

    @Generated
    public void setErrorMessage(Component errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setLastFocus(int lastFocus) {
        this.lastFocus = lastFocus;
    }

    @Generated
    public void setSoundManager(SoundManager soundManager) {
        this.soundManager = soundManager;
    }

    @Generated
    public void setLastCheckTick(long lastCheckTick) {
        this.lastCheckTick = lastCheckTick;
    }

    @Generated
    public void setCraftingStatus(CraftingStatus craftingStatus) {
        this.craftingStatus = craftingStatus;
    }
}

