/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.jei.IJeiRequirement;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public abstract class JeiComponent<X, R extends RecipeRequirement<?, ?>>
implements IIngredientRenderer<X>,
IJeiRequirement<R> {
    protected static final ResourceLocation LOCATION_JEI_ICONS = ResourceLocation.fromNamespaceAndPath((String)"modular_machinery_reborn", (String)"textures/gui/jeirecipeicons.png");
    protected R requirement;
    protected final int uOffset;
    protected final int vOffset;

    protected JeiComponent(R requirement, int uOffset, int vOffset) {
        this.requirement = requirement;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public ResourceLocation texture() {
        return LOCATION_JEI_ICONS;
    }

    public void render(GuiGraphics guiGraphics, @NotNull X ingredient) {
        guiGraphics.blit(this.texture(), -1, -1, 0, (float)this.uOffset, (float)this.vOffset, this.getWidth(), this.getHeight(), TextureSizeHelper.getWidth(this.texture()), TextureSizeHelper.getHeight(this.texture()));
    }

    @NotNull
    public List<Component> getTooltip(@NotNull X ingredient, @NotNull TooltipFlag tooltipFlag) {
        return new LinkedList<Component>();
    }

    public abstract List<X> ingredients();

    public RecipeIngredientRole role() {
        if (this.requirement == null) {
            return RecipeIngredientRole.RENDER_ONLY;
        }
        return ((RecipeRequirement)this.requirement).requirement().getMode().isInput() ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
    }

    @Override
    @Generated
    public R getRequirement() {
        return this.requirement;
    }

    @Generated
    public int getUOffset() {
        return this.uOffset;
    }

    @Generated
    public int getVOffset() {
        return this.vOffset;
    }

    @Generated
    public void setRequirement(R requirement) {
        this.requirement = requirement;
    }
}

