/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.integration.kubejs.KubeJSIntegration;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.FunctionComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class RequirementFunction
implements IRequirement<FunctionComponent> {
    public static final NamedCodec<RequirementFunction> CODEC = NamedCodec.record(functionRequirementInstance -> functionRequirementInstance.group(NamedCodec.enumCodec(Phase.class).fieldOf("phase").forGetter(RequirementFunction::getPhase), NamedCodec.STRING.fieldOf("id").forGetter(RequirementFunction::getIdentifier)).apply((Applicative)functionRequirementInstance, RequirementFunction::new), "Function requirement");
    public static final List<RequirementFunction> errors = new ArrayList<RequirementFunction>();
    private final Phase phase;
    private final String identifier;

    public RequirementFunction(Phase phase, String id) {
        this.phase = phase;
        this.identifier = id;
    }

    @Override
    public RequirementType<? extends IRequirement<FunctionComponent>> getType() {
        return RequirementTypeRegistration.FUNCTION.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_FUNCTION.get();
    }

    @Override
    public IOType getMode() {
        return IOType.NONE;
    }

    @Override
    public boolean test(FunctionComponent component, ICraftingContext context) {
        return this.phase != Phase.CHECK || this.execute(component, context).isSuccess();
    }

    @Override
    public void gatherRequirements(IRequirementList<FunctionComponent> list) {
        switch (this.phase.ordinal()) {
            case 1: {
                list.processOnStart(this::execute);
                break;
            }
            case 2: {
                list.processEachTick(this::execute);
                break;
            }
            case 3: {
                list.processOnEnd(this::execute);
            }
        }
    }

    private CraftingResult execute(FunctionComponent component, ICraftingContext context) {
        if (errors.contains(this)) {
            return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.function"));
        }
        try {
            if (ModList.get().isLoaded("kubejs")) {
                return KubeJSIntegration.sendFunctionRequirementEvent(this.identifier, context);
            }
            throw new IllegalStateException("Trying to process function requirement for identifier: " + this.identifier + " without KubeJS installed !");
        }
        catch (Throwable error) {
            errors.add(this);
            if (ModList.get().isLoaded("kubejs")) {
                KubeJSIntegration.logError(error);
            }
            return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.function"));
        }
    }

    @Override
    public PositionedRequirement getPosition() {
        return new PositionedRequirement(0, 0);
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.function");
    }

    @Override
    public boolean isComponentValid(FunctionComponent m, ICraftingContext context) {
        return this.getMode().equals((Object)m.getIOType());
    }

    @Generated
    public Phase getPhase() {
        return this.phase;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    public static enum Phase {
        CHECK,
        START,
        TICK,
        END;

    }
}

