/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipeSerializer;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementEnergy;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MachineRecipe
implements Comparable<MachineRecipe>,
Recipe<RecipeInput> {
    public static final NamedMapCodec<MachineRecipeBuilder> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("machine").forGetter(MachineRecipeBuilder::getMachine), NamedCodec.intRange(1, Integer.MAX_VALUE).fieldOf("time").forGetter(MachineRecipeBuilder::getTime), RecipeRequirement.CODEC.listOf().fieldOf("requirements").forGetter(MachineRecipeBuilder::getRequirements), NamedCodec.INT.optionalFieldOf("priority", 0).forGetter(MachineRecipeBuilder::getPrio), NamedCodec.BOOL.optionalFieldOf("voidFailure", true).forGetter(MachineRecipeBuilder::isVoidF), NamedCodec.INT.optionalFieldOf("width", 256).forGetter(MachineRecipeBuilder::getWidth), NamedCodec.INT.optionalFieldOf("height", 256).forGetter(MachineRecipeBuilder::getHeight), NamedCodec.BOOL.optionalFieldOf("renderProgress", true).forGetter(MachineRecipeBuilder::isShouldRenderProgress), PositionedRequirement.POSITION_CODEC.optionalFieldOf("progressPosition", new PositionedRequirement(74, 8)).forGetter(MachineRecipeBuilder::getProgressPosition)).apply((Applicative)instance, MachineRecipeBuilder::new), "Machine recipe");
    private final ResourceLocation owningMachine;
    private final int tickTime;
    private final List<RecipeRequirement<?, ?>> recipeRequirements = Lists.newArrayList();
    private final int configuredPriority;
    private final boolean voidPerTickFailure;
    private final PositionedRequirement progressPosition;
    private final int width;
    private final int height;
    public final List<Component> textsToRender = Lists.newArrayList();
    public final List<Pair<PositionedSizedRequirement, Object>> chanceTexts = Lists.newArrayList();
    private final boolean shouldRenderProgress;
    private boolean modified = false;

    public MachineRecipe(ResourceLocation owningMachine, int tickTime, int configuredPriority, boolean voidPerTickFailure, int width, int height, boolean shouldRenderProgress, PositionedRequirement progressPosition) {
        this.owningMachine = owningMachine;
        this.tickTime = tickTime;
        this.configuredPriority = configuredPriority;
        this.voidPerTickFailure = voidPerTickFailure;
        this.progressPosition = progressPosition;
        this.shouldRenderProgress = shouldRenderProgress;
        this.width = width;
        this.height = height;
    }

    public ResourceLocation getOwningMachineIdentifier() {
        return this.owningMachine;
    }

    public List<RecipeRequirement<?, ?>> getRequirements() {
        return this.recipeRequirements;
    }

    public void addRequirement(RecipeRequirement<?, ?> requirement) {
        if (requirement.requirement() instanceof RequirementEnergy) {
            for (RecipeRequirement<?, ?> req : this.getRequirements()) {
                if (!(req.requirement() instanceof RequirementEnergy) || req.requirement().getMode() != requirement.requirement().getMode()) continue;
                throw new IllegalStateException("Tried to add multiple energy requirements for the same ioType! Please only add one for each ioType!");
            }
        }
        if (requirement.isModified()) {
            this.setModified(true);
        }
        this.recipeRequirements.add(requirement);
    }

    public int getRecipeTotalTickTime() {
        return this.tickTime;
    }

    public boolean doesCancelRecipeOnPerTickFailure() {
        return this.voidPerTickFailure;
    }

    @Nullable
    public DynamicMachine getOwningMachine() {
        return (DynamicMachine)ModularMachineryReborn.MACHINES.get((Object)this.getOwningMachineIdentifier());
    }

    @Override
    public int compareTo(MachineRecipe o) {
        return Integer.compare(this.buildWeight(), o.buildWeight());
    }

    private int buildWeight() {
        return this.configuredPriority;
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("owningMachine", this.owningMachine.toString());
        json.addProperty("tickTime", (Number)this.tickTime);
        JsonArray recipeRequirements = new JsonArray();
        this.recipeRequirements.forEach(req -> recipeRequirements.add((JsonElement)req.asJson()));
        json.add("recipeRequirements", (JsonElement)recipeRequirements);
        json.addProperty("configuredPriority", (Number)this.configuredPriority);
        json.addProperty("voidPerTickFailure", Boolean.valueOf(this.voidPerTickFailure));
        json.addProperty("shouldRenderProgress", Boolean.valueOf(this.shouldRenderProgress));
        json.add("progressPosition", (JsonElement)this.progressPosition.asJson());
        json.addProperty("modifiedByAU", Boolean.valueOf(this.modified));
        return json;
    }

    public String toString() {
        return this.asJson().toString();
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public MachineRecipeSerializer getSerializer() {
        return RecipeRegistration.RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistration.RECIPE_TYPE.get();
    }

    @Generated
    public List<RecipeRequirement<?, ?>> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    @Generated
    public int getConfiguredPriority() {
        return this.configuredPriority;
    }

    @Generated
    public boolean isVoidPerTickFailure() {
        return this.voidPerTickFailure;
    }

    @Generated
    public PositionedRequirement getProgressPosition() {
        return this.progressPosition;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public List<Component> getTextsToRender() {
        return this.textsToRender;
    }

    @Generated
    public List<Pair<PositionedSizedRequirement, Object>> getChanceTexts() {
        return this.chanceTexts;
    }

    @Generated
    public boolean isShouldRenderProgress() {
        return this.shouldRenderProgress;
    }

    @Generated
    public boolean isModified() {
        return this.modified;
    }

    @Generated
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public static class MachineRecipeBuilder {
        private final ResourceLocation machine;
        private final PositionedRequirement progressPosition;
        private final int time;
        private final int width;
        private final int height;
        private int prio;
        private boolean shouldRenderProgress;
        private final List<RecipeRequirement<?, ?>> requirements;
        private boolean voidF;
        private boolean modified;

        public MachineRecipeBuilder(ResourceLocation machine, int time, int width, int height, PositionedRequirement progressPosition) {
            this.requirements = Lists.newArrayList();
            this.machine = machine;
            this.time = time;
            this.progressPosition = progressPosition;
            this.width = width;
            this.height = height;
        }

        public void modified(boolean modified) {
            this.modified = modified;
        }

        public void withPriority(int prio) {
            this.prio = prio;
        }

        public void shouldVoidOnFailure(boolean v) {
            this.voidF = v;
        }

        public void shouldRenderProgress(boolean v) {
            this.shouldRenderProgress = v;
        }

        public void addRequirement(RecipeRequirement<?, ?> requirement) {
            this.requirements.add(requirement);
            if (requirement.isModified()) {
                this.modified(true);
            }
        }

        public MachineRecipeBuilder(ResourceLocation machine, int time, List<RecipeRequirement<?, ?>> requirements, int prio, boolean voidF, int width, int height, boolean shouldRenderProgress, PositionedRequirement progressPosition) {
            this.machine = machine;
            this.time = time;
            this.requirements = requirements;
            this.prio = prio;
            this.voidF = voidF;
            this.progressPosition = progressPosition;
            this.shouldRenderProgress = shouldRenderProgress;
            this.width = width;
            this.height = height;
        }

        public MachineRecipeBuilder(MachineRecipe recipe) {
            this(recipe.getOwningMachineIdentifier(), recipe.tickTime, recipe.recipeRequirements, recipe.configuredPriority, recipe.voidPerTickFailure, recipe.width, recipe.height, recipe.shouldRenderProgress, recipe.progressPosition);
            this.modified(recipe.modified);
        }

        public MachineRecipe build() {
            try {
                MMRLogger.INSTANCE.info("Building recipe...");
                MachineRecipe recipe = new MachineRecipe(this.machine, this.time, this.prio, this.voidF, this.width, this.height, this.shouldRenderProgress, this.progressPosition);
                this.requirements.forEach(recipe::addRequirement);
                if (!recipe.modified) {
                    recipe.setModified(this.modified);
                }
                MMRLogger.INSTANCE.info("Finished building recipe {}", (Object)recipe);
                return recipe;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Generated
        public ResourceLocation getMachine() {
            return this.machine;
        }

        @Generated
        public PositionedRequirement getProgressPosition() {
            return this.progressPosition;
        }

        @Generated
        public int getTime() {
            return this.time;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public int getPrio() {
            return this.prio;
        }

        @Generated
        public boolean isShouldRenderProgress() {
            return this.shouldRenderProgress;
        }

        @Generated
        public List<RecipeRequirement<?, ?>> getRequirements() {
            return this.requirements;
        }

        @Generated
        public boolean isVoidF() {
            return this.voidF;
        }

        @Generated
        public boolean isModified() {
            return this.modified;
        }
    }
}

