/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.common.block.BlockFluidHatch;
import es.degrassi.mmreborn.common.block.prop.FluidHatchSize;
import es.degrassi.mmreborn.common.entity.FluidOutputHatchEntity;
import es.degrassi.mmreborn.common.item.FluidHatchItem;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFluidOutputHatch
extends BlockFluidHatch {
    public BlockFluidOutputHatch(FluidHatchSize size) {
        super(size);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new FluidOutputHatchEntity(blockPos, blockState, this.size);
    }

    @Override
    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        switch (this.size) {
            case TINY: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_TINY.get()).getDefaultInstance());
                break;
            }
            case SMALL: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_SMALL.get()).getDefaultInstance());
                break;
            }
            case NORMAL: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_NORMAL.get()).getDefaultInstance());
                break;
            }
            case REINFORCED: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_REINFORCED.get()).getDefaultInstance());
                break;
            }
            case BIG: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_BIG.get()).getDefaultInstance());
                break;
            }
            case HUGE: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_HUGE.get()).getDefaultInstance());
                break;
            }
            case LUDICROUS: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_LUDICROUS.get()).getDefaultInstance());
                break;
            }
            case VACUUM: {
                drops.add(((FluidHatchItem)ItemRegistration.FLUID_OUTPUT_HATCH_VACUUM.get()).getDefaultInstance());
            }
        }
        return drops;
    }
}

