/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.EnergyHatchContainer;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class EnergyHatchScreen
extends BaseScreen<EnergyHatchContainer, EnergyHatchEntity> {
    public EnergyHatchScreen(EnergyHatchContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    @Override
    public ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("textures/gui/guibar.png");
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        guiGraphics.pose().pushPose();
        float percFilled = (float)((EnergyHatchEntity)this.entity).getCurrentEnergy() / (float)((EnergyHatchEntity)this.entity).getMaxEnergy();
        int pxFilled = Mth.ceil((float)(percFilled * 61.0f));
        guiGraphics.blit(this.getTexture(), this.leftPos + 15, this.topPos + 10 + 61 - pxFilled, 196, 61 - pxFilled, 20, pxFilled);
        guiGraphics.pose().popPose();
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int offsetX = (this.width - this.getXSize()) / 2;
        int offsetZ = (this.height - this.getYSize()) / 2;
        if (x >= 15 + offsetX && x <= 35 + offsetX && y >= 10 + offsetZ && y <= 71 + offsetZ) {
            long currentEnergy = EnergyDisplayUtil.type.formatEnergyForDisplay(((EnergyHatchEntity)this.entity).getCurrentEnergy());
            long maxEnergy = EnergyDisplayUtil.type.formatEnergyForDisplay(((EnergyHatchEntity)this.entity).getMaxEnergy());
            MutableComponent text = Component.translatable((String)"tooltip.energyhatch.charge", (Object[])new Object[]{String.valueOf(currentEnergy), String.valueOf(maxEnergy), Component.translatable((String)EnergyDisplayUtil.type.getUnlocalizedFormat())});
            Font font = Minecraft.getInstance().font;
            guiGraphics.renderTooltip(font, (Component)text, x, y);
        }
    }
}

