/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.item;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class MMRItemTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation CHECK = ModularMachineryReborn.rl("textures/gui/check.png");
    private final ItemStack stack;
    private final Component text;
    private final int textWidth;
    private final int textHeight;
    private final boolean completed;
    private final int iconWidth;

    public MMRItemTooltip(ItemStack stack, Component text, boolean completed) {
        this.stack = stack;
        this.text = text;
        this.iconWidth = TextureSizeHelper.getWidth(CHECK);
        int maxTextWidth = Minecraft.getInstance().font.width("100x [#modular_machinery_reborn:energyoutputhatch]");
        this.textWidth = Math.min(Minecraft.getInstance().font.width((FormattedText)text), maxTextWidth);
        this.textHeight = Minecraft.getInstance().font.wordWrapHeight((FormattedText)text, maxTextWidth);
        this.completed = completed;
    }

    public int getHeight() {
        return Math.max(this.textHeight, 18) + 6;
    }

    public int getWidth(Font font) {
        return 24 + this.textWidth + this.iconWidth;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.renderItem(this.stack, x, y);
        guiGraphics.renderItemDecorations(font, this.stack, x, y);
        if (this.completed) {
            guiGraphics.blit(CHECK, x + 16 + 8 + Math.min(font.width((FormattedText)this.text), this.textWidth), y, 0.0f, 0.0f, TextureSizeHelper.getWidth(CHECK), TextureSizeHelper.getHeight(CHECK), TextureSizeHelper.getWidth(CHECK), TextureSizeHelper.getHeight(CHECK));
        }
        guiGraphics.drawWordWrap(font, (FormattedText)this.text, x + 16 + 4, y + 6, this.textWidth, -1);
    }
}

