/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.client.util.RenderTypes;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.util.CycleTimer;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class StructureRenderer {
    private final int time;
    private final long start;
    private final Map<Direction, Map<BlockPos, BlockIngredient>> blocksGetter = new HashMap<Direction, Map<BlockPos, BlockIngredient>>();
    private final Map<Map<BlockPos, BlockIngredient>, CycleTimer> timers = new HashMap<Map<BlockPos, BlockIngredient>, CycleTimer>();

    public StructureRenderer(int time, Function<Direction, Map<BlockPos, BlockIngredient>> blocksGetter) {
        this.start = System.currentTimeMillis();
        AtomicInteger maxTime = new AtomicInteger(time);
        for (Direction direction : Direction.values()) {
            if (direction.getAxis().isVertical()) continue;
            this.blocksGetter.put(direction, blocksGetter.apply(direction));
            Map<BlockPos, BlockIngredient> map = this.blocksGetter.get(direction);
            map.forEach((pos, ing) -> maxTime.set(Math.max(maxTime.get(), map.size() * (Integer)MMRConfig.get().blockTagCycleTime.get())));
            this.timers.put(map, new CycleTimer(() -> (Integer)MMRConfig.get().blockTagCycleTime.get(), false));
        }
        this.time = maxTime.get();
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, Direction direction, Level world, BlockPos machinePos) {
        Map<BlockPos, BlockIngredient> blocks = this.blocksGetter.get(direction);
        CycleTimer timer = this.timers.get(blocks);
        if (timer == null) {
            this.timers.put(blocks, new CycleTimer(() -> (Integer)MMRConfig.get().blockTagCycleTime.get(), false));
            timer = this.timers.get(blocks);
        }
        timer.onDraw();
        MMRLogger.INSTANCE.debug(blocks);
        CycleTimer finalTimer = timer;
        blocks.forEach((pos, ingredient) -> {
            matrix.pushPose();
            matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if ((pos.getX() != 0 || pos.getY() != 0 || pos.getZ() != 0) && ingredient != BlockIngredient.ANY) {
                PartialBlockState state = finalTimer.get(ingredient.getAll());
                BlockPos blockPos = machinePos.offset((Vec3i)pos);
                if (state != null && state != PartialBlockState.ANY && !state.getBlockState().isAir()) {
                    if (world.getBlockState(blockPos).isAir()) {
                        matrix.translate(0.1f, 0.1f, 0.1f);
                        this.renderTransparentBlock(state, matrix, buffer, 1.0f, 1.0f, 0.8f);
                    } else if (ingredient.getAll().stream().noneMatch(test -> test.test(new BlockInWorld((LevelReader)world, blockPos, false)))) {
                        matrix.translate(-5.0E-4, -5.0E-4, -5.0E-4);
                        this.renderTransparentBlock(state, matrix, buffer, 0.0f, 0.0f, 1.001f);
                    }
                }
            }
            matrix.popPose();
        });
    }

    private void renderTransparentBlock(PartialBlockState state, PoseStack matrix, MultiBufferSource buffer, float green, float blue, float scale) {
        VertexConsumer builder = buffer.getBuffer(RenderTypes.PHANTOM);
        matrix.scale(scale, scale, scale);
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state.getBlockState());
        if (model != Minecraft.getInstance().getModelManager().getMissingModel()) {
            Arrays.stream(Direction.values()).flatMap(direction -> model.getQuads(state.getBlockState(), direction, RandomSource.create((long)42L)).stream()).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, green, blue, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
            model.getQuads(state.getBlockState(), null, RandomSource.create((long)42L)).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, green, blue, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
        }
    }

    private void renderNope(PoseStack matrix, MultiBufferSource buffer) {
        VertexConsumer builder = buffer.getBuffer(RenderTypes.NOPE);
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("block/nope")));
        matrix.translate(-5.0E-4, -5.0E-4, -5.0E-4);
        matrix.scale(1.001f, 1.001f, 1.001f);
        Arrays.stream(Direction.values()).flatMap(direction -> model.getQuads(null, direction, RandomSource.create((long)42L)).stream()).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 0.8f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
        model.getQuads(null, null, RandomSource.create((long)42L)).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 0.8f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
    }

    public boolean shouldRender() {
        return System.currentTimeMillis() < this.start + (long)this.time;
    }
}

