/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class ClientScheduler {
    private static long clientTick = 0L;
    private static final Object lock = new Object();
    private boolean inTick = false;
    private final Map<Runnable, Counter> queuedRunnables = Maps.newHashMap();
    private final Map<Runnable, Integer> waitingRunnables = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tick(ClientTickEvent.Pre event) {
        ++clientTick;
        this.inTick = true;
        Object object = lock;
        synchronized (object) {
            this.inTick = true;
            Iterator<Runnable> iterator = this.queuedRunnables.keySet().iterator();
            while (iterator.hasNext()) {
                Runnable r = iterator.next();
                Counter delay = this.queuedRunnables.get(r);
                delay.decrement();
                if (delay.value > 0) continue;
                r.run();
                iterator.remove();
            }
            this.inTick = false;
            for (Map.Entry<Runnable, Integer> waiting : this.waitingRunnables.entrySet()) {
                this.queuedRunnables.put(waiting.getKey(), new Counter(waiting.getValue()));
            }
        }
        this.waitingRunnables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunnable(Runnable r, int tickDelay) {
        Object object = lock;
        synchronized (object) {
            if (this.inTick) {
                this.waitingRunnables.put(r, tickDelay);
            } else {
                this.queuedRunnables.put(r, new Counter(tickDelay));
            }
        }
    }

    @Generated
    public static long getClientTick() {
        return clientTick;
    }

    public static class Counter {
        public int value;

        public Counter(int value) {
            this.value = value;
        }

        public void decrement() {
            --this.value;
        }

        public void increment() {
            ++this.value;
        }
    }
}

