/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.network.syncable;

import es.degrassi.mmreborn.api.network.AbstractSyncable;
import es.degrassi.mmreborn.api.network.data.FluidStackData;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class FluidStackSyncable
extends AbstractSyncable<FluidStackData, FluidStack> {
    @Override
    public FluidStackData getData(short id) {
        return new FluidStackData(id, (FluidStack)this.get());
    }

    @Override
    public boolean needSync() {
        FluidStack value = (FluidStack)this.get();
        boolean needSync = this.lastKnownValue != null ? !FluidStack.matches((FluidStack)value, (FluidStack)((FluidStack)this.lastKnownValue)) : true;
        this.lastKnownValue = value.copy();
        return needSync;
    }

    public static FluidStackSyncable create(final Supplier<FluidStack> supplier, final Consumer<FluidStack> consumer) {
        return new FluidStackSyncable(){

            @Override
            public FluidStack get() {
                return (FluidStack)supplier.get();
            }

            @Override
            public void set(FluidStack value) {
                consumer.accept(value);
            }
        };
    }
}

