/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.integration.almostunified;

import com.almostreliable.unified.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.integration.almostunified.AlmostUnifiedAdapter;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public final class RecipeIndicator {
    public static final int RENDER_SIZE = 10;
    private static final int TEXTURE_SIZE = 16;
    private static final ResourceLocation TEXTURE = Utils.getRL((String)"textures/ingot.png");

    private RecipeIndicator() {
    }

    public static void renderIndicator(GuiGraphics guiGraphics, int pX, int pY, int size) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)pX, (float)pY, 0.0f);
        float scale = (float)size / 16.0f;
        poseStack.scale(scale, scale, scale);
        guiGraphics.blit(TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.popPose();
    }

    public static List<Component> constructTooltip(MachineRecipe link) {
        MutableComponent unified = Component.translatable((String)Utils.prefix((String)"unified")).append(": ").withStyle(c -> c.withColor(ChatFormatting.AQUA));
        unified.append((Component)Component.translatable((String)Utils.prefix((String)(AlmostUnifiedAdapter.isRecipeModified(link) ? "yes" : "no"))).withStyle(c -> c.withColor(ChatFormatting.WHITE)));
        MutableComponent duplicate = Component.translatable((String)Utils.prefix((String)"duplicate")).append(": ").withStyle(c -> c.withColor(ChatFormatting.AQUA));
        duplicate.append((Component)Component.translatable((String)Utils.prefix((String)"no")).withStyle(c -> c.withColor(ChatFormatting.WHITE)));
        return List.of(Component.translatable((String)Utils.prefix((String)"description")).withStyle(c -> c.withColor(ChatFormatting.GOLD)), Component.literal((String)" "), unified, duplicate, Component.literal((String)" "), Component.translatable((String)Utils.prefix((String)"warning")).withStyle(c -> c.withColor(ChatFormatting.RED)));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, MachineRecipe link, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        Screen screen = mc.screen;
        if (screen == null) {
            return;
        }
        List tooltip = RecipeIndicator.constructTooltip(link).stream().map(c -> font.split((FormattedText)c, screen.width - (int)mouseX - 200)).flatMap(Collection::stream).toList();
        guiGraphics.renderTooltip(font, tooltip, (int)mouseX, (int)mouseY);
    }
}

