/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.mmreborn.api.network.DataType;
import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.common.block.BlockController;
import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import es.degrassi.mmreborn.common.block.prop.FluidHatchSize;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.block.prop.ParallelHatchSize;
import es.degrassi.mmreborn.common.command.MMRCommand;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.integration.theoneprobe.TOPInfoProvider;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.MachineJsonReloadListener;
import es.degrassi.mmreborn.common.manager.crafting.ProcessorType;
import es.degrassi.mmreborn.common.network.server.SLootTablesPacket;
import es.degrassi.mmreborn.common.network.server.SSyncMachinesPacket;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.DataRegistration;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.ProcessorTypeRegistration;
import es.degrassi.mmreborn.common.registration.Registration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.LoggingLevel;
import es.degrassi.mmreborn.common.util.LootTableHelper;
import es.degrassi.mmreborn.common.util.MMRLogger;
import es.degrassi.mmreborn.common.util.MiscUtils;
import java.util.Locale;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Mod(value="modular_machinery_reborn")
public class ModularMachineryReborn {
    public static final String MODID = "modular_machinery_reborn";
    public static final Logger LOGGER = LogManager.getLogger((String)"Modular Machinery Reborn");
    public static final BiMap<ResourceLocation, DynamicMachine> MACHINES = HashBiMap.create();
    public static final BiMap<ResourceLocation, BlockController> MACHINES_BLOCK = HashBiMap.create();

    public ModularMachineryReborn(ModContainer CONTAINER, IEventBus MOD_BUS) {
        CONTAINER.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MMRConfig.getSpec(), String.format("%s/base/common.toml", MODID));
        ModularMachineryReborn.addConfigLoaders();
        Registration.register(MOD_BUS);
        MOD_BUS.addListener(this::commonSetup);
        MOD_BUS.addListener(this::sendIMCMessages);
        MOD_BUS.addListener(this::registerCapabilities);
        MOD_BUS.addListener(this::reloadConfig);
        IEventBus GAME_BUS = NeoForge.EVENT_BUS;
        GAME_BUS.addListener(this::serverStarting);
        GAME_BUS.addListener(this::syncDatapacks);
        GAME_BUS.addListener(this::registerReloadListener);
        GAME_BUS.addListener(this::registerCommands);
        GAME_BUS.addListener(this::onReloadStart);
    }

    private static void addConfigLoaders() {
        ConfigLoaded.add(Pair.of(EnergyHatchSize.class, size -> {
            size.maxEnergy = MMRConfig.get().energySize((EnergyHatchSize)size);
            size.maxEnergy = MiscUtils.clamp(size.maxEnergy, 1L, Long.MAX_VALUE);
            size.transferLimit = MMRConfig.get().energyLimit((EnergyHatchSize)size);
            size.transferLimit = MiscUtils.clamp(size.transferLimit, 1L, Long.MAX_VALUE);
        }), Pair.of(FluidHatchSize.class, size -> {
            size.size = MMRConfig.get().fluidSize((FluidHatchSize)size);
        }), Pair.of(ItemBusSize.class, size -> {
            size.slots = MMRConfig.get().itemSize((ItemBusSize)size);
            size.cols = MMRConfig.get().itemCols((ItemBusSize)size);
        }), Pair.of(ExperienceHatchSize.class, size -> {
            size.capacity = MMRConfig.get().experienceSize((ExperienceHatchSize)size);
        }), Pair.of(ParallelHatchSize.class, size -> {
            size.max = MMRConfig.get().maxParallel((ParallelHatchSize)size);
        }));
    }

    private void sendIMCMessages(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPInfoProvider::new);
        }
    }

    private void serverStarting(ServerStartingEvent event) {
        LootTableHelper.generate(event.getServer());
    }

    private void syncDatapacks(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            this.syncData(event.getPlayer());
        } else {
            LootTableHelper.generate(event.getPlayerList().getServer());
            event.getPlayerList().getPlayers().forEach(this::syncData);
        }
    }

    public void syncData(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SSyncMachinesPacket((Map<ResourceLocation, DynamicMachine>)MACHINES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SLootTablesPacket(LootTableHelper.getLoots()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MMRLogger.init();
        Config.load();
        ConfigLoaded.load();
        EnergyDisplayUtil.loadFromConfig();
    }

    private void reloadConfig(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == MMRConfig.getSpec()) {
            MMRLogger.setDebugLevel(((LoggingLevel)((Object)MMRConfig.get().debugLevel.get())).getLevel());
            Config.load();
            ConfigLoaded.load();
            EnergyDisplayUtil.loadFromConfig();
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, EntityRegistration.ITEM_INPUT_BUS.get(), (be, side) -> be.getInventory());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, EntityRegistration.ITEM_OUTPUT_BUS.get(), (be, side) -> be.getInventory());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, EntityRegistration.FLUID_INPUT_HATCH.get(), (be, side) -> be.getTank());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, EntityRegistration.FLUID_OUTPUT_HATCH.get(), (be, side) -> be.getTank());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, EntityRegistration.ENERGY_INPUT_HATCH.get(), (be, side) -> be);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, EntityRegistration.ENERGY_OUTPUT_HATCH.get(), (be, side) -> be);
        event.registerBlockEntity(ExperienceLibCapabilities.EXPERIENCE.block(), EntityRegistration.EXPERIENCE_INPUT_HATCH.get(), (be, side) -> be.getTank());
        event.registerBlockEntity(ExperienceLibCapabilities.EXPERIENCE.block(), EntityRegistration.EXPERIENCE_OUTPUT_HATCH.get(), (be, side) -> be.getTank());
    }

    private void registerReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new MachineJsonReloadListener());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path.toLowerCase(Locale.ROOT));
    }

    public static String rootLC(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public static String rootUC(String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(MMRCommand.register("modularmachineryreborn"));
        event.getDispatcher().register(MMRCommand.register("modularmachinery"));
        event.getDispatcher().register(MMRCommand.register(MODID));
        event.getDispatcher().register(MMRCommand.register("modular_machinery"));
        event.getDispatcher().register(MMRCommand.register("mmr"));
        event.getDispatcher().register(MMRCommand.register("mm"));
    }

    private void onReloadStart(CommandEvent event) {
        if (event.getParseResults().getReader().getString().equals("reload") && ((CommandSourceStack)event.getParseResults().getContext().getSource()).hasPermission(2)) {
            MMRLogger.reset();
            ConfigLoaded.load();
            Config.load();
            EnergyDisplayUtil.loadFromConfig();
            Entity entity = ((CommandSourceStack)event.getParseResults().getContext().getSource()).getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                MMRCommand.reloadMachines(player.server, player);
            }
        }
    }

    public static Registry<ProcessorType<?>> processorRegistrar() {
        return ProcessorTypeRegistration.PROCESSOR_REGISTRY;
    }

    public static Registry<RequirementType<?>> getRequirementRegistrar() {
        return RequirementTypeRegistration.REQUIREMENTS_REGISTRY;
    }

    public static Registry<ComponentType> getComponentRegistrar() {
        return ComponentRegistration.COMPONENTS_REGISTRY;
    }

    public static Registry<DataType<?, ?>> dataRegistrar() {
        return DataRegistration.DATA_REGISTRY;
    }
}

