/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.SecurityHelper;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractNetworkEnergyItem;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.security.BuiltinPermission;
import com.refinedmods.refinedstorage.quartzarsenal.common.ContentNames;
import com.refinedmods.refinedstorage.quartzarsenal.common.Platform;
import com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid.WirelessCraftingGrid;
import com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid.WirelessCraftingGridExtendedMenuProvider;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WirelessCraftingGridItem
extends AbstractNetworkEnergyItem {
    private final boolean creative;

    public WirelessCraftingGridItem(boolean creative, EnergyItemHelper energyItemHelper, NetworkItemHelper networkItemHelper) {
        super(new Item.Properties().stacksTo(1), energyItemHelper, networkItemHelper);
        this.creative = creative;
    }

    public EnergyStorage createEnergyStorage(ItemStack stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.getConfig().getWirelessCraftingGrid().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asItemEnergyStorage((EnergyStorage)energyStorage, stack);
    }

    protected void use(@Nullable Component name, ServerPlayer player, SlotReference slotReference, NetworkItemContext context) {
        boolean isAllowed = context.resolveNetwork().map(network -> SecurityHelper.isAllowed((ServerPlayer)player, (Permission)BuiltinPermission.OPEN, (Network)network)).orElse(true);
        if (!isAllowed) {
            RefinedStorageApi.INSTANCE.sendNoPermissionToOpenMessage(player, (Component)ContentNames.WIRELESS_CRAFTING_GRID);
            return;
        }
        WirelessCraftingGrid craftingGrid = new WirelessCraftingGrid((Player)player, context, slotReference);
        Component correctedName = (Component)Objects.requireNonNullElse(name, this.creative ? ContentNames.CREATIVE_WIRELESS_CRAFTING_GRID : ContentNames.WIRELESS_CRAFTING_GRID);
        WirelessCraftingGridExtendedMenuProvider provider = new WirelessCraftingGridExtendedMenuProvider(correctedName, craftingGrid, slotReference);
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.getMenuOpener().openMenu(player, (MenuProvider)provider);
    }
}

