/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityLaserRelayEnergy
extends TileEntityLaserRelay {
    public static final int CAP = 1000;
    public final ConcurrentHashMap<Direction, BlockEntity> receiversAround = new ConcurrentHashMap();
    private final IEnergyStorage[] energyStorages = new IEnergyStorage[6];
    private Mode mode = Mode.BOTH;

    public TileEntityLaserRelayEnergy(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, LaserType.ENERGY);
        for (int i = 0; i < this.energyStorages.length; ++i) {
            final Direction facing = Direction.values()[i];
            this.energyStorages[i] = new IEnergyStorage(){

                public int receiveEnergy(int amount, boolean simulate) {
                    return TileEntityLaserRelayEnergy.this.transmitEnergy(facing, amount, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int getEnergyStored() {
                    return 0;
                }

                public int getMaxEnergyStored() {
                    return TileEntityLaserRelayEnergy.this.getEnergyCap();
                }

                public boolean canExtract() {
                    return false;
                }

                public boolean canReceive() {
                    return true;
                }
            };
        }
    }

    public TileEntityLaserRelayEnergy(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.LASER_RELAY.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayEnergy) {
            TileEntityLaserRelayEnergy tile = (TileEntityLaserRelayEnergy)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayEnergy) {
            TileEntityLaserRelayEnergy tile = (TileEntityLaserRelayEnergy)t;
            tile.serverTick();
        }
    }

    private int transmitEnergy(Direction from, int maxTransmit, boolean simulate) {
        Network network;
        int transmitted = 0;
        if (maxTransmit > 0 && this.mode != Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferEnergyToReceiverInNeed(from, network, maxTransmit, simulate);
        }
        return transmitted;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.energyStorages[facing == null ? 0 : facing.ordinal()];
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<Direction, BlockEntity> old = new HashMap<Direction, BlockEntity>(this.receiversAround);
        boolean change = false;
        this.receiversAround.clear();
        for (Direction side : Direction.values()) {
            BlockEntity tile;
            BlockPos pos = this.getBlockPos().relative(side);
            if (!this.level.hasChunkAt(pos) || (tile = this.level.getBlockEntity(pos)) == null || tile instanceof TileEntityLaserRelay || this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), (Object)side.getOpposite()) == null) continue;
            this.receiversAround.put(side, tile);
            BlockEntity oldTile = (BlockEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.receiversAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    private int transferEnergyToReceiverInNeed(Direction from, Network network, int maxTransfer, boolean simulate) {
        int transmitted = 0;
        ObjectOpenHashSet alreadyChecked = new ObjectOpenHashSet();
        ObjectOpenHashSet relaysThatWork = new ObjectOpenHashSet();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.level.hasChunkAt(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                BlockEntity relayTile = this.level.getBlockEntity(relay);
                if (!(relayTile instanceof TileEntityLaserRelayEnergy)) continue;
                TileEntityLaserRelayEnergy theRelay = (TileEntityLaserRelayEnergy)relayTile;
                if (theRelay.mode == Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (Direction facing : theRelay.receiversAround.keySet()) {
                    Boolean received;
                    if (theRelay == this && facing == from) continue;
                    BlockEntity tile = theRelay.receiversAround.get(facing);
                    Direction opp = facing.getOpposite();
                    if (tile == null || !(received = Optional.ofNullable((IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), (Object)opp)).map(cap -> cap.receiveEnergy(maxTransfer, true) > 0).orElse(false)).booleanValue()) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = maxTransfer / totalReceiverAmount <= 0 ? maxTransfer : maxTransfer / totalReceiverAmount;
            for (TileEntityLaserRelayEnergy theRelay : relaysThatWork) {
                double highestLoss = Math.max(theRelay.getLossPercentage(), this.getLossPercentage());
                int lowestCap = Math.min(theRelay.getEnergyCap(), this.getEnergyCap());
                for (Map.Entry<Direction, BlockEntity> receiver : theRelay.receiversAround.entrySet()) {
                    if (receiver == null) continue;
                    Direction side = receiver.getKey();
                    Direction opp = side.getOpposite();
                    BlockEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.getBlockPos())) continue;
                    alreadyChecked.add(tile.getBlockPos());
                    if (theRelay == this && side == from || (transmitted += Optional.ofNullable((IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), (Object)opp)).map(cap -> {
                        int trans = 0;
                        int theoreticalReceived = cap.receiveEnergy(Math.min(amountPer, lowestCap), true);
                        if (theoreticalReceived > 0) {
                            int actual;
                            int deduct = this.calcDeduction(theoreticalReceived, highestLoss);
                            if (deduct >= theoreticalReceived) {
                                deduct = 0;
                            }
                            if ((actual = cap.receiveEnergy(theoreticalReceived - deduct, simulate)) > 0) {
                                trans += actual;
                                trans += deduct;
                            }
                        }
                        return trans;
                    }).orElse(0).intValue()) < maxTransfer) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    private int calcDeduction(int theoreticalReceived, double highestLoss) {
        return (Boolean)CommonConfig.Machines.LASER_RELAY_LOSS.get() != false ? Mth.ceil((double)((double)theoreticalReceived * (highestLoss / 100.0))) : 0;
    }

    public int getEnergyCap() {
        return 1000;
    }

    public double getLossPercentage() {
        return 5.0;
    }

    @Override
    public Component getExtraDisplayString() {
        return Component.translatable((String)"info.actuallyadditions.laserRelay.energy.extra").append(": ").append((Component)Component.translatable((String)this.mode.name).withStyle(ChatFormatting.DARK_RED));
    }

    @Override
    public Component getCompassDisplayString() {
        return Component.translatable((String)"info.actuallyadditions.laserRelay.energy.display").withStyle(ChatFormatting.GREEN);
    }

    @Override
    public void onCompassAction(Player player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putString("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.getString("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = Mode.valueOf(modeStrg);
        }
    }

    public static enum Mode {
        BOTH("info.actuallyadditions.laserRelay.mode.both"),
        OUTPUT_ONLY("info.actuallyadditions.laserRelay.mode.outputOnly"),
        INPUT_ONLY("info.actuallyadditions.laserRelay.mode.inputOnly");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }

        public Mode getNext() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= Mode.values().length) {
                ordinal = 0;
            }
            return Mode.values()[ordinal];
        }
    }
}

