/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.util.VanillaPacketDispatcher;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class TileEntityBase
extends BlockEntity {
    public boolean isRedstonePowered;
    public boolean isPulseMode;
    public boolean stopFromDropping;
    protected int ticksElapsed;
    protected BlockEntity[] tilesAround = new BlockEntity[6];
    protected boolean hasSavedDataOnChangeOrWorldStart;
    private boolean shareEnergy = this instanceof ISharingEnergyProvider;
    private boolean shareFluid = this instanceof ISharingFluidHandler;

    public TileEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        this.writeSyncableNBT(compound, lookupProvider, NBTType.SAVE_TILE);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        this.readSyncableNBT(compound, lookupProvider, NBTType.SAVE_TILE);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compound = new CompoundTag();
        this.writeSyncableNBT(compound, (HolderLookup.Provider)(this.level != null ? this.level.registryAccess() : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)), NBTType.SYNC);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        if (pkt.getTag() != null) {
            this.readSyncableNBT(pkt.getTag(), lookupProvider, NBTType.SYNC);
        }
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag compound = new CompoundTag();
        this.writeSyncableNBT(compound, lookupProvider, NBTType.SYNC);
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.readSyncableNBT(tag, lookupProvider, NBTType.SYNC);
    }

    public final void sendUpdate() {
        if (this.level != null && !this.level.isClientSide) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, NBTType type) {
        if (type != NBTType.SAVE_BLOCK) {
            super.saveAdditional(compound, lookupProvider);
        }
        if (type == NBTType.SAVE_TILE) {
            compound.putBoolean("Redstone", this.isRedstonePowered);
            compound.putInt("TicksElapsed", this.ticksElapsed);
            compound.putBoolean("StopDrop", this.stopFromDropping);
        } else if (type == NBTType.SYNC && this.stopFromDropping) {
            compound.putBoolean("StopDrop", this.stopFromDropping);
        }
        if (this.isRedstoneToggle() && (type != NBTType.SAVE_BLOCK || this.isPulseMode)) {
            compound.putBoolean("IsPulseMode", this.isPulseMode);
        }
    }

    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, NBTType type) {
        if (type != NBTType.SAVE_BLOCK) {
            super.loadAdditional(compound, lookupProvider);
        }
        if (type == NBTType.SAVE_TILE) {
            this.isRedstonePowered = compound.getBoolean("Redstone");
            this.ticksElapsed = compound.getInt("TicksElapsed");
            this.stopFromDropping = compound.getBoolean("StopDrop");
        } else if (type == NBTType.SYNC) {
            this.stopFromDropping = compound.getBoolean("StopDrop");
        }
        if (this.isRedstoneToggle() && compound.contains("IsPulseMode")) {
            this.isPulseMode = compound.getBoolean("IsPulseMode");
        }
    }

    public int getComparatorStrength() {
        return 0;
    }

    protected void clientTick() {
        ++this.ticksElapsed;
    }

    protected void serverTick() {
        ISharingFluidHandler handler;
        BlockEntity tile;
        int amount;
        Direction[] sides;
        int total;
        ISharingEnergyProvider provider;
        ++this.ticksElapsed;
        if (this.shareEnergy && (provider = (ISharingEnergyProvider)((Object)this)).doesShareEnergy() && (total = provider.getEnergyToSplitShare()) > 0) {
            sides = provider.getEnergyShareSides();
            amount = total / sides.length;
            if (amount <= 0) {
                amount = total;
            }
            for (Direction side : sides) {
                tile = this.tilesAround[side.ordinal()];
                if (tile == null || !provider.canShareTo(tile)) continue;
                WorldUtil.doEnergyInteraction(this.level, this.getBlockPos(), tile.getBlockPos(), side, amount);
            }
        }
        if (this.shareFluid && (handler = (ISharingFluidHandler)((Object)this)).doesShareFluid() && (total = handler.getMaxFluidAmountToSplitShare()) > 0) {
            sides = handler.getFluidShareSides();
            amount = total / sides.length;
            if (amount <= 0) {
                amount = total;
            }
            for (Direction side : sides) {
                tile = this.tilesAround[side.ordinal()];
                if (tile == null) continue;
                WorldUtil.doFluidInteraction(this.level, this.getBlockPos(), tile.getBlockPos(), side, amount);
            }
        }
        if (!this.hasSavedDataOnChangeOrWorldStart) {
            if (this.shouldSaveDataOnChangeOrWorldStart()) {
                this.saveDataOnChangeOrWorldStart();
            }
            this.hasSavedDataOnChangeOrWorldStart = true;
        }
    }

    public void saveDataOnChangeOrWorldStart() {
        for (Direction side : Direction.values()) {
            BlockPos pos = this.worldPosition.relative(side);
            if (!this.level.hasChunkAt(pos)) continue;
            this.tilesAround[side.ordinal()] = this.level.getBlockEntity(pos);
        }
    }

    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return this instanceof ISharingEnergyProvider || this instanceof ISharingFluidHandler;
    }

    public void setRedstonePowered(boolean powered) {
        this.isRedstonePowered = powered;
        this.setChanged();
    }

    public boolean canPlayerUse(Player player) {
        return player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) <= 64.0 && !this.isRemoved() && this.level.getBlockEntity(this.worldPosition) == this;
    }

    protected boolean sendUpdateWithInterval() {
        if (this.ticksElapsed % 5 == 0) {
            this.sendUpdate();
            return true;
        }
        return false;
    }

    public IFluidHandler getFluidHandler(Direction facing) {
        return null;
    }

    public IEnergyStorage getEnergyStorage(Direction facing) {
        return null;
    }

    public IItemHandler getItemHandler(Direction facing) {
        return null;
    }

    public boolean isRedstoneToggle() {
        return false;
    }

    public void activateOnPulse() {
    }

    public boolean respondsToPulses() {
        return this.isRedstoneToggle() && this.isPulseMode;
    }

    public static enum NBTType {
        SAVE_TILE,
        SYNC,
        SAVE_BLOCK;

    }
}

