/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.particle.ActuallyParticles;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record BeamParticleData(double endX, double endY, double endZ, int color, int maxAge, double rotationTime, float size) implements ParticleOptions
{
    public static final MapCodec<BeamParticleData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("endX").forGetter(d -> d.endX), (App)Codec.DOUBLE.fieldOf("endY").forGetter(d -> d.endY), (App)Codec.DOUBLE.fieldOf("endZ").forGetter(d -> d.endZ), (App)Codec.INT.fieldOf("color").forGetter(d -> d.color), (App)Codec.INT.fieldOf("maxAge").forGetter(d -> d.maxAge), (App)Codec.DOUBLE.fieldOf("rotationTime").forGetter(d -> d.rotationTime), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size))).apply((Applicative)instance, BeamParticleData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BeamParticleData> STREAM_CODEC = StreamCodec.of(BeamParticleData::toNetwork, BeamParticleData::fromNetwork);

    public static BeamParticleData fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
        return new BeamParticleData(pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readInt(), pBuffer.readInt(), pBuffer.readDouble(), pBuffer.readFloat());
    }

    public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, BeamParticleData pRecipe) {
        pBuffer.writeDouble(pRecipe.endX());
        pBuffer.writeDouble(pRecipe.endY());
        pBuffer.writeDouble(pRecipe.endZ());
        pBuffer.writeInt(pRecipe.color());
        pBuffer.writeInt(pRecipe.maxAge());
        pBuffer.writeDouble(pRecipe.rotationTime());
        pBuffer.writeFloat(pRecipe.size());
    }

    public ParticleType<?> getType() {
        return ActuallyParticles.BEAM.get();
    }
}

