/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ItemCrafterOnAStick
extends ItemBase {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.crafting");

    public ItemCrafterOnAStick() {
        super(ActuallyItems.defaultNonStacking());
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!world.isClientSide) {
            ItemCrafterOnAStick.openCraftingMenu(player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public static void openCraftingMenu(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CraftingMenu(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition())){

            public boolean stillValid(@NotNull Player playerIn) {
                return true;
            }
        }, CONTAINER_TITLE));
    }

    public static boolean hasCrafterOnAStick(@Nonnull Player player) {
        Optional curiosInv;
        if (player.getMainHandItem().getItem() instanceof ItemCrafterOnAStick || player.getOffhandItem().getItem() instanceof ItemCrafterOnAStick) {
            return true;
        }
        if (Util.curiosLoaded && (curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && ((ICuriosItemHandler)curiosInv.get()).findFirstCurio(ItemCrafterOnAStick::isCrafterOnAStick).isPresent()) {
            return true;
        }
        Inventory inventory = player.getInventory();
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!(stack.getItem() instanceof ItemCrafterOnAStick)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCrafterOnAStick(@Nonnull ItemStack stack) {
        return stack.getItem() instanceof ItemCrafterOnAStick;
    }
}

