/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class Filler
extends ItemEnergy {
    public Filler() {
        super(500000, 1000);
    }

    private static boolean removeFittingItem(BlockState state, Player player) {
        Block block = state.getBlock();
        ItemStack stack = new ItemStack((ItemLike)block, 1);
        if (!stack.isEmpty()) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack slot = player.getInventory().getItem(i);
                if (slot.isEmpty() || !ItemStack.isSameItem((ItemStack)slot, (ItemStack)stack)) continue;
                slot.shrink(1);
                if (slot.isEmpty()) {
                    player.getInventory().setItem(i, ItemStack.EMPTY);
                }
                return true;
            }
        }
        return false;
    }

    private static void saveData(BlockState state, ItemStack wand) {
        wand.set(ActuallyComponents.BLOCKSTATE, (Object)state);
    }

    private static Optional<BlockState> loadData(ItemStack stack) {
        if (stack.has(ActuallyComponents.BLOCKSTATE)) {
            return Optional.ofNullable((BlockState)stack.get(ActuallyComponents.BLOCKSTATE));
        }
        return Optional.empty();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        if (!context.getLevel().isClientSide && context.getPlayer().getUseItemRemainingTicks() <= 0) {
            if (context.getPlayer().isCrouching()) {
                BlockState state = context.getLevel().getBlockState(context.getClickedPos());
                Filler.saveData(state, stack);
                return InteractionResult.SUCCESS;
            }
            if (Filler.loadData(stack).isPresent() && ((BlockPos)stack.getOrDefault(ActuallyComponents.FILLER_CURRENT, (Object)BlockPos.ZERO)).equals((Object)BlockPos.ZERO)) {
                stack.set(ActuallyComponents.FILLER_FIRST, (Object)new BlockPos((Vec3i)context.getClickedPos()));
                context.getPlayer().startUsingItem(context.getHand());
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public void releaseUsing(@Nonnull ItemStack stack, Level world, @Nonnull LivingEntity entity, int timeLeft) {
        if (!world.isClientSide) {
            Player player;
            HitResult result;
            boolean clear = true;
            if (entity instanceof Player && (result = (player = (Player)entity).pick(Util.getReachDistance(player), 1.0f, false)) instanceof BlockHitResult) {
                BlockPos pos = ((BlockHitResult)result).getBlockPos();
                stack.set(ActuallyComponents.FILLER_SECOND, (Object)new BlockPos((Vec3i)pos));
                clear = false;
            }
            if (clear) {
                ItemPhantomConnector.clearStorage(stack, ActuallyComponents.FILLER_FIRST.get(), ActuallyComponents.FILLER_SECOND.get(), ActuallyComponents.FILLER_CURRENT.get());
            }
        }
        super.releaseUsing(stack, world, entity, timeLeft);
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!world.isClientSide) {
            boolean shouldClear = false;
            if (isSelected) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    boolean creative = player.isCreative();
                    BlockPos firstPos = (BlockPos)stack.getOrDefault(ActuallyComponents.FILLER_FIRST, (Object)BlockPos.ZERO);
                    BlockPos secondPos = (BlockPos)stack.getOrDefault(ActuallyComponents.FILLER_SECOND, (Object)BlockPos.ZERO);
                    BlockPos currentPos = (BlockPos)stack.getOrDefault(ActuallyComponents.FILLER_CURRENT, (Object)BlockPos.ZERO);
                    if (!BlockPos.ZERO.equals((Object)firstPos) && !BlockPos.ZERO.equals((Object)secondPos)) {
                        int energyUse = 1500;
                        Optional<BlockState> data = Filler.loadData(stack);
                        if (data.isPresent() && (creative || this.getEnergyStored(stack) >= energyUse)) {
                            int currZ;
                            int currY;
                            BlockState replaceState = data.get();
                            int lowestX = Math.min(firstPos.getX(), secondPos.getX());
                            int lowestY = Math.min(firstPos.getY(), secondPos.getY());
                            int lowestZ = Math.min(firstPos.getZ(), secondPos.getZ());
                            int currX = currentPos.getX();
                            BlockPos pos = new BlockPos(lowestX + currX, lowestY + (currY = currentPos.getY()), lowestZ + (currZ = currentPos.getZ()));
                            BlockState state = world.getBlockState(pos);
                            if (state.canBeReplaced() && replaceState.canSurvive((LevelReader)world, pos)) {
                                if (creative || Filler.removeFittingItem(replaceState, player)) {
                                    world.setBlock(pos, replaceState, 2);
                                    SoundType sound = replaceState.getBlock().getSoundType(replaceState, (LevelReader)world, pos, (Entity)player);
                                    world.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, sound.getVolume() / 2.0f + 0.5f, sound.getPitch() * 0.8f);
                                    if (!creative) {
                                        this.extractEnergy(stack, energyUse, false);
                                    }
                                } else {
                                    shouldClear = true;
                                }
                            }
                            int distX = Math.abs(secondPos.getX() - firstPos.getX());
                            int distY = Math.abs(secondPos.getY() - firstPos.getY());
                            int distZ = Math.abs(secondPos.getZ() - firstPos.getZ());
                            if (++currX > distX) {
                                currX = 0;
                                if (++currY > distY) {
                                    currY = 0;
                                    if (++currZ > distZ) {
                                        shouldClear = true;
                                    }
                                }
                            }
                            if (!shouldClear) {
                                stack.set(ActuallyComponents.FILLER_CURRENT, (Object)new BlockPos(currX, currY, currZ));
                            }
                        } else {
                            shouldClear = true;
                        }
                    }
                }
            } else {
                shouldClear = true;
            }
            if (shouldClear) {
                ItemPhantomConnector.clearStorage(stack, ActuallyComponents.FILLER_FIRST.get(), ActuallyComponents.FILLER_SECOND.get(), ActuallyComponents.FILLER_CURRENT.get());
            }
        }
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        MutableComponent display = Filler.loadData(stack).map(state -> state.getBlock().getName()).orElse(Component.translatable((String)"tooltip.actuallyadditions.item_filling_wand.selected_block.none"));
        tooltip.add((Component)Component.translatable((String)"tooltip.actuallyadditions.item_filling_wand.selected_block", (Object[])new Object[]{display.getString()}));
    }

    public int getUseDuration(@Nonnull ItemStack stack, @Nonnull LivingEntity livingEntity) {
        return Integer.MAX_VALUE;
    }
}

