/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.ItemBattery;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBatteryBox;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.Lang;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.joml.Matrix4f;

public class RenderBatteryBox
implements BlockEntityRenderer<TileEntityBatteryBox> {
    public RenderBatteryBox(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityBatteryBox tile, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack stack = tile.inv.getStackInSlot(0);
        if (stack.isEmpty() || !(stack.getItem() instanceof ItemBattery)) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5f, 0.35f, 0.5f);
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrices.pushPose();
        matrices.scale(0.0075f, 0.0075f, 0.0075f);
        matrices.translate(0.0f, 0.0f, -60.0f);
        Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(cap -> {
            Font font = Minecraft.getInstance().font;
            String energyTotal = Lang.cleanEnergyValues(cap, false);
            MutableComponent energyName = Component.translatable((String)"misc.actuallyadditions.power_name_long");
            float backgroundOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int j = (int)(backgroundOpacity * 255.0f) << 24;
            for (int i = 0; i < 4; ++i) {
                Matrix4f pose = matrices.last().pose();
                font.drawInBatch(energyTotal, (float)(-font.width(energyTotal)) / 2.0f, 10.0f, 0xFFFFFF, false, pose, buffer, Font.DisplayMode.NORMAL, j, combinedLight);
                font.drawInBatch((Component)energyName, (float)(-font.width((FormattedText)energyName)) / 2.0f, 20.0f, 0xFFFFFF, false, pose, buffer, Font.DisplayMode.NORMAL, j, combinedLight);
                matrices.translate(-60.0f, 0.0f, 60.0f);
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
        });
        matrices.popPose();
        matrices.popPose();
        double boop = (double)Util.getMillis() / 800.0;
        float scale = stack.getItem() instanceof BlockItem ? 0.85f : 0.65f;
        matrices.pushPose();
        matrices.translate(0.5, 1.0 + Math.sin(boop % (Math.PI * 2)) * 0.065, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees((float)(boop * 40.0 % 360.0)));
        matrices.scale(scale, scale, scale);
        try {
            AssetUtil.renderItemInWorld(stack, combinedLight, combinedOverlay, matrices, buffer);
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.error("Something went wrong trying to render an item in a battery box! The item is {}!", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)e);
        }
        matrices.popPose();
    }
}

