/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.extension;

import com.almostreliable.ponderjs.particles.ParticleInstructions;
import com.google.common.base.Preconditions;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.InputElementBuilder;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

@RemapPrefixForJS(value="ponderjs$")
public interface SceneBuilderExtension {
    @HideFromJS
    public SceneBuilder ponderjs$self();

    @HideFromJS
    public PonderScene ponderjs$getScene();

    public ParticleInstructions ponderjs$getParticles();

    default public void ponderjs$showStructure() {
        this.ponderjs$showStructure(this.ponderjs$getScene().getBasePlateSize() * 2);
    }

    default public void ponderjs$showStructure(int height) {
        BlockPos start = new BlockPos(this.ponderjs$getScene().getBasePlateOffsetX(), 0, this.ponderjs$getScene().getBasePlateOffsetZ());
        BlockPos size = start.offset(this.ponderjs$getScene().getBasePlateSize() - 1, height, this.ponderjs$getScene().getBasePlateSize() - 1);
        Selection selection = this.ponderjs$getScene().getSceneBuildingUtil().select().cuboid(start, (Vec3i)size);
        this.ponderjs$self().world().showSection(selection, Direction.UP);
    }

    default public void ponderjs$encapsulateBounds(BlockPos size) {
        this.ponderjs$self().addInstruction(ps -> ps.getWorld().getBounds().encapsulate(size));
    }

    default public void ponderjs$playSound(SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
        Preconditions.checkArgument((soundEvent != null ? 1 : 0) != 0, (Object)"Given sound does not exist");
        this.ponderjs$self().addInstruction(ps -> {
            if (Minecraft.getInstance().player == null) {
                return;
            }
            SimpleSoundInstance sound = new SimpleSoundInstance(soundEvent, soundSource, volume, pitch, SoundInstance.createUnseededRandom(), Minecraft.getInstance().player.blockPosition());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
        });
    }

    default public void ponderjs$playSound(SoundEvent soundEvent, float volume) {
        this.ponderjs$playSound(soundEvent, SoundSource.MASTER, volume, 1.0f);
    }

    default public void ponderjs$playSound(SoundEvent soundEvent) {
        this.ponderjs$playSound(soundEvent, SoundSource.MASTER, 1.0f, 1.0f);
    }

    default public TextElementBuilder ponderjs$text(int duration, String text) {
        return this.ponderjs$self().overlay().showText(duration).text(text);
    }

    default public TextElementBuilder ponderjs$text(int duration, String text, Vec3 position) {
        return this.ponderjs$self().overlay().showText(duration).text(text).pointAt(position);
    }

    default public TextElementBuilder ponderjs$sharedText(int duration, ResourceLocation key) {
        return this.ponderjs$self().overlay().showText(duration).sharedText(key);
    }

    default public TextElementBuilder ponderjs$sharedText(int duration, ResourceLocation key, Vec3 position) {
        return this.ponderjs$self().overlay().showText(duration).sharedText(key).pointAt(position).colored(PonderPalette.BLUE);
    }

    default public InputElementBuilder ponderjs$showControls(int duration, Vec3 pos, Pointing pointing) {
        return this.ponderjs$self().overlay().showControls(pos, pointing, duration);
    }
}

