/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderBuilderJS;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.createmod.ponder.foundation.registration.PonderSceneRegistry;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PonderRegistryEventJS
implements KubeEvent {
    private final PonderSceneRegistry sceneRegistry;

    public PonderRegistryEventJS(PonderSceneRegistry sceneRegistry) {
        this.sceneRegistry = sceneRegistry;
    }

    public PonderBuilderJS create(Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("Provided items must not be empty!");
        }
        Set<ResourceLocation> itemIds = Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).collect(Collectors.toSet());
        return new PonderBuilderJS(itemIds, this.sceneRegistry);
    }

    public void printParticleNames() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("### Particles ###").append("\n");
        BuiltInRegistries.PARTICLE_TYPE.stream().filter(SimpleParticleType.class::isInstance).map(arg_0 -> ((Registry)BuiltInRegistries.PARTICLE_TYPE).getKey(arg_0)).sorted().forEach(id -> sb.append(" - ").append(id).append("\n"));
        ConsoleJS.CLIENT.info((Object)sb.toString());
    }
}

