/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.support;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceSlot;
import com.ultramega.cabletiers.common.utils.TagFiltering;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public abstract class AbstractTieredFilterContainerMenu<T extends TagFiltering>
extends AbstractResourceContainerMenu {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    protected final CableTiers tier;
    protected int playerInventoryY;
    private final Component filterHelp;
    @Nullable
    private TagFiltering blockEntity;
    @Nullable
    private List<ResourceTag> tagKeys;

    protected AbstractTieredFilterContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainer resourceContainer, @Nullable UpgradeContainer upgradeContainer, T blockEntity, int playerInventoryY, Component filterHelp, CableTiers tier) {
        super(type, syncId, player);
        this.filterHelp = filterHelp;
        this.tier = tier;
        this.blockEntity = blockEntity;
        this.playerInventoryY = playerInventoryY;
        this.registerServerProperties(blockEntity);
        this.addSlots(player, resourceContainer, upgradeContainer);
        this.blockEntity.setOnChanged(() -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                blockEntity.sendFilterTagsToClient(serverPlayer);
            }
        });
    }

    protected AbstractTieredFilterContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainerData resourceContainerData, @Nullable UpgradeDestination upgradeDestination, int playerInventoryY, Component filterHelp, CableTiers tier) {
        super(type, syncId);
        this.filterHelp = filterHelp;
        this.tier = tier;
        this.playerInventoryY = playerInventoryY;
        this.registerClientProperties();
        this.addSlots(player, ResourceContainerImpl.createForFilter((ResourceContainerData)resourceContainerData), upgradeDestination == null ? null : new UpgradeContainer(upgradeDestination));
    }

    protected abstract void registerClientProperties();

    protected abstract void registerServerProperties(T var1);

    protected void addSlots(Player player, ResourceContainer resourceContainer, @Nullable UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < resourceContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(resourceContainer, i));
        }
        if (upgradeContainer != null) {
            for (i = 0; i < upgradeContainer.getContainerSize(); ++i) {
                this.addSlot((Slot)new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
            }
        }
        this.addPlayerInventory(player.getInventory(), 8, this.playerInventoryY);
        if (upgradeContainer != null) {
            this.transferManager.addBiTransfer((Container)player.getInventory(), (Container)upgradeContainer);
        }
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * (i % 9);
        return new AdvancedResourceSlot(this, this.player, resourceContainer, i, this.filterHelp, x, 20 + 18 * (i / 9), ResourceSlotType.FILTER);
    }

    public void removed(Player player) {
        if (this.blockEntity != null) {
            this.blockEntity.setInContainerMenu(false);
            this.blockEntity.resetFakeFilters();
        }
        super.removed(player);
    }

    public void setTagFilter(int slotIndex, @Nullable ResourceTag resourceTag) {
        if (this.blockEntity != null) {
            this.blockEntity.setTagFilter(slotIndex, resourceTag);
        }
    }

    @Nullable
    public TagKey<?> getTagFilter(int slotIndex) {
        if (this.blockEntity != null) {
            return this.blockEntity.getTagFilter(slotIndex);
        }
        return null;
    }

    public void setTagKeys(List<ResourceTag> tagKeys) {
        this.tagKeys = tagKeys;
    }

    @Nullable
    public List<ResourceTag> getTagKeys() {
        return this.tagKeys;
    }
}

