/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.constructordestructor;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.constructordestructor.AbstractConstructorDestructorBlock;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.constructordestructor.AbstractTieredDestructorBlockEntity;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.utils.BlockEntityTierProvider;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TieredDestructorBlock
extends AbstractConstructorDestructorBlock<TieredDestructorBlock, AbstractTieredDestructorBlockEntity, BaseBlockItem>
implements BlockItemProvider<BaseBlockItem> {
    private static final Component HELP_1 = IdentifierUtil.createTranslation((String)"item", (String)"destructor.help");
    private static final Component HELP_2 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_cable.help");
    private final CableTiers tier;
    private final BlockEntityTierProvider<AbstractTieredDestructorBlockEntity> blockEntityProvider;

    public TieredDestructorBlock(DyeColor color, MutableComponent name, CableTiers tier, BlockEntityTierProvider<AbstractTieredDestructorBlockEntity> blockEntityProvider) {
        super(color, name, (AbstractBlockEntityTicker)new NetworkNodeBlockEntityTicker(() -> BlockEntities.INSTANCE.getTieredDestructors(tier), ACTIVE));
        this.tier = tier;
        this.blockEntityProvider = blockEntityProvider;
    }

    public BlockColorMap<TieredDestructorBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getTieredDestructors(this.tier);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityProvider.create(this.tier, pos, state);
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, null){

            public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
                return Optional.of(new HelpTooltipComponent((Component)Component.literal((String)(HELP_1.getString() + " " + String.format(HELP_2.getString(), TieredDestructorBlock.this.tier.getSpeed(CableType.DESTRUCTOR) + "x", TieredDestructorBlock.this.tier.getFilterSlotsCount())))));
            }
        };
    }
}

