/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.constructordestructor;

import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorData;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.SchedulingModeContainer;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.constructordestructor.AutocraftOnMissingResourcesConstructorStrategy;
import com.ultramega.cabletiers.common.constructordestructor.CompositeConstructorStrategy;
import com.ultramega.cabletiers.common.constructordestructor.TieredConstructorContainerMenu;
import com.ultramega.cabletiers.common.constructordestructor.TieredConstructorNetworkNode;
import com.ultramega.cabletiers.common.exporter.TieredExportingIndicators;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.support.AbstractTieredCableLikeBlockEntity;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AbstractTieredConstructorBlockEntity
extends AbstractTieredCableLikeBlockEntity<TieredConstructorNetworkNode>
implements NetworkNodeExtendedMenuProvider<ConstructorData> {
    private static final String TAG_DROP_ITEMS = "di";
    private final SchedulingModeContainer schedulingModeContainer;
    private boolean dropItems;

    protected AbstractTieredConstructorBlockEntity(final CableTiers tier, BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getTieredConstructors(tier), pos, state, new TieredConstructorNetworkNode(tier.getEnergyUsage(CableType.CONSTRUCTOR)), tier, CableType.CONSTRUCTOR);
        this.filter = TagFilterWithFuzzyMode.createAndListenForFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::setChanged, this::setFilters);
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredConstructorBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((TieredConstructorNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.CONSTRUCTOR) + upgradeEnergyUsage);
            this.setChanged();
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                this.initialize(serverLevel);
            }
        }, Math.max(1, 20 - tier.getSpeed(CableType.CONSTRUCTOR))){

            public boolean has(UpgradeItem upgradeItem) {
                if (tier.hasIntegratedStackUpgrade(CableType.CONSTRUCTOR) && upgradeItem == Items.INSTANCE.getStackUpgrade()) {
                    return true;
                }
                return super.has(upgradeItem);
            }

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.schedulingModeContainer = new SchedulingModeContainer(schedulingMode -> {
            ((TieredConstructorNetworkNode)this.mainNetworkNode).setSchedulingMode((SchedulingMode)schedulingMode);
            this.setChanged();
        });
        this.ticker = this.upgradeContainer.getTicker();
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier == CableTiers.CREATIVE ? TieredUpgradeDestinations.CONSTRUCTOR_NO_STACK_SPEED : (tier.hasIntegratedStackUpgrade(CableType.CONSTRUCTOR) ? TieredUpgradeDestinations.CONSTRUCTOR_NO_STACK : UpgradeDestinations.CONSTRUCTOR);
    }

    void setFilters(List<ResourceKey> filters, List<ResourceTag> tagFilters) {
        ((TieredConstructorNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    void setSchedulingModeType(SchedulingModeType type) {
        this.schedulingModeContainer.setType(type);
    }

    SchedulingModeType getSchedulingModeType() {
        return this.schedulingModeContainer.getType();
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    boolean isDropItems() {
        return this.dropItems;
    }

    void setDropItems(boolean dropItems) {
        this.dropItems = dropItems;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putBoolean(TAG_DROP_ITEMS, this.dropItems);
        this.schedulingModeContainer.writeToTag(tag);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_DROP_ITEMS)) {
            this.dropItems = tag.getBoolean(TAG_DROP_ITEMS);
        }
        this.schedulingModeContainer.loadFromTag(tag);
    }

    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ((TieredConstructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((TieredConstructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private ConstructorStrategy createStrategy(ServerLevel serverLevel, Direction direction) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        Collection factories = RefinedStorageApi.INSTANCE.getConstructorStrategyFactories();
        List<ConstructorStrategy> strategies = factories.stream().flatMap(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)this.upgradeContainer, this.dropItems).stream()).toList();
        CompositeConstructorStrategy strategy = new CompositeConstructorStrategy(strategies);
        if (this.upgradeContainer.has((UpgradeItem)Items.INSTANCE.getAutocraftingUpgrade())) {
            return new AutocraftOnMissingResourcesConstructorStrategy(strategy);
        }
        return strategy;
    }

    public ConstructorData getMenuData() {
        return new ConstructorData(ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer()), this.getExportingIndicators().getAll());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ConstructorData> getMenuCodec() {
        return ConstructorData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)this.tier.getContentName(CableType.CONSTRUCTOR));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        this.setInContainerMenu(true);
        return new TieredConstructorContainerMenu(syncId, player, this, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators(), this.tier);
    }

    private TieredExportingIndicators getExportingIndicators() {
        return new TieredExportingIndicators(this.filter.getFilterContainer(), (i, j) -> this.toExportingIndicator(((TieredConstructorNetworkNode)this.mainNetworkNode).getLastResult(i, j)), false);
    }

    private ExportingIndicator toExportingIndicator(@Nullable ConstructorStrategy.Result result) {
        ConstructorStrategy.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (ConstructorStrategy.Result)result2, n)) {
            case 0 -> ExportingIndicator.RESOURCE_MISSING;
            case 1 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 2 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }
}

