/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.sidedinput;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridScreen;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.packet.c2s.SetSidedResourcesOnPatternGridBlockPacket;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import com.ultramega.cabletiers.common.utils.ResourceSlotRendering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SidedInputScreen
extends Screen {
    private static final ResourceLocation TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/sided_input.png");
    private static final ResourceLocation SLOT_TEXTURE = IdentifierUtil.createIdentifier((String)"slot");
    private static final ResourceLocation DIRECTION_BUTTON = IdentifierUtil.createIdentifier((String)"widget/side_button/base");
    private static final ResourceLocation DIRECTION_BUTTON_HOVERED = IdentifierUtil.createIdentifier((String)"widget/side_button/hovered");
    private static final ResourceLocation DIRECTION_BUTTON_OVERLAY = IdentifierUtil.createIdentifier((String)"widget/side_button/hover_overlay");
    private static final MutableComponent NONE = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.none");
    private static final MutableComponent DOWN = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.down");
    private static final MutableComponent UP = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.up");
    private static final MutableComponent NORTH = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.north");
    private static final MutableComponent SOUTH = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.south");
    private static final MutableComponent WEST = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.west");
    private static final MutableComponent EAST = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.east");
    private static final MutableComponent INPUT_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"pattern_grid.processing.input_slots_help");
    private static final int DIRECTION_SIZE = 14;
    private static final int INDIVIDUAL_SLOT_SIZE = 18;
    private final PatternGridContainerMenu gridContainerMenu;
    private final Component gridTitle;
    private final List<ResourceSlot> processingInputSlots = new ArrayList<ResourceSlot>();
    @Nullable
    private List<Component> tooltip = new ArrayList<Component>();
    private final int imageWidth;
    private final int imageHeight;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private final Direction[] directions;
    private int hoveringDirectionRow;
    private int hoveringDirectionColumn;
    private int leftPos;
    private int topPos;

    public SidedInputScreen(PatternGridContainerMenu gridContainerMenu, Component gridTitle, List<Optional<SidedResourceAmount>> sidedResources) {
        super((Component)Component.empty());
        int i;
        this.gridContainerMenu = gridContainerMenu;
        this.gridTitle = gridTitle;
        for (i = 0; i < gridContainerMenu.getResourceSlots().size(); ++i) {
            ResourceSlot slot = (ResourceSlot)gridContainerMenu.getResourceSlots().get(i);
            if (!SidedInputScreen.isProcessingInputSlot(slot)) continue;
            this.processingInputSlots.add(slot);
        }
        this.directions = new Direction[this.processingInputSlots.size()];
        i = 0;
        for (Optional<SidedResourceAmount> resource : sidedResources) {
            if (resource.isPresent() && i < this.directions.length) {
                this.directions[i] = resource.get().inputDirection().orElse(null);
            }
            ++i;
        }
        this.imageWidth = 140;
        this.imageHeight = 99;
    }

    public static boolean isProcessingInputSlot(ResourceSlot slot) {
        return slot.getHelpText().equals((Object)INPUT_HELP);
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.scrollbar = this.createScrollbar();
        this.updateScrollbarMaxOffset();
        this.addRenderableWidget((GuiEventListener)this.scrollbar);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int startY = this.topPos + 6;
        int endY = this.topPos + 6 + 88 + 1;
        graphics.enableScissor(this.leftPos - 50, startY, this.leftPos + this.imageWidth + 50, endY);
        this.renderSlotsAndDirections(graphics, mouseX, mouseY);
        graphics.disableScissor();
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTick);
        }
        this.renderHoveredResourceTooltip(graphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderTransparentBackground(guiGraphics);
    }

    private void renderSlotsAndDirections(GuiGraphics graphics, int mouseX, int mouseY) {
        int xx = this.leftPos + 5;
        int startY = this.topPos + 9 - 18;
        int endY = this.topPos + 9 + 72;
        boolean anyHovered = false;
        for (int i = 0; i < this.processingInputSlots.size(); ++i) {
            ResourceSlot slot = this.processingInputSlots.get(i);
            if (this.directions == null || this.directions.length <= i) {
                return;
            }
            int yy = this.getYForScrollbarOffset(i);
            if (yy < startY || yy > endY) continue;
            int slotX = xx + 1;
            int slotY = yy + 1;
            boolean hovering = this.isHovering(slotX, slotY, 16, 16, mouseX, mouseY);
            graphics.blitSprite(SLOT_TEXTURE, xx, yy, 18, 18);
            if (slot.getResource() != null && this.gridContainerMenu.getRepository().isSticky((ResourceKey)slot.getResource())) {
                AbstractGridScreen.renderSlotBackground((GuiGraphics)graphics, (int)slotX, (int)slotY, (boolean)false, (int)AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
            }
            List<Component> resourceTooltips = ResourceSlotRendering.render(graphics, slot, slotX, slotY);
            if (hovering) {
                anyHovered = true;
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)slotX, (int)slotY, (int)0);
                this.tooltip = resourceTooltips;
            }
            Direction selectedDirection = this.directions[i];
            for (int j = -1; j < Direction.values().length; ++j) {
                boolean isClicked;
                Direction direction = j == -1 ? null : Direction.values()[j];
                MutableComponent name = direction == null ? NONE : SidedInputScreen.getDirectionName(direction);
                String shortName = direction == null ? "X" : name.getString().substring(0, 1);
                int x = slotX + 4 + 14 * (j + 2);
                int y = slotY + 1;
                boolean isEmpty = slot.isEmpty();
                boolean isHovered = this.isHovering(x + 1, y + 1, 12, 12, mouseX, mouseY);
                boolean bl = selectedDirection == null ? j == -1 : (isClicked = j == selectedDirection.ordinal());
                if (!this.renderDirectionButton(graphics, x, y, shortName, isEmpty, isHovered, isClicked)) continue;
                anyHovered = true;
                this.tooltip = List.of(name);
                this.hoveringDirectionRow = i;
                this.hoveringDirectionColumn = j;
            }
        }
        if (!anyHovered) {
            this.tooltip = null;
            this.hoveringDirectionRow = -1;
            this.hoveringDirectionColumn = -2;
        }
    }

    private boolean renderDirectionButton(GuiGraphics graphics, int x, int y, String text, boolean isEmpty, boolean isHovered, boolean isClicked) {
        graphics.blitSprite(!isEmpty && (isHovered || isClicked) ? DIRECTION_BUTTON_HOVERED : DIRECTION_BUTTON, x, y, 14, 14);
        int textWidth = this.font.width(text);
        int textX = x + (14 - textWidth) / 2;
        Objects.requireNonNull(this.font);
        int textY = y + (14 - 9) / 2 + 1;
        graphics.drawString(this.font, text, textX, textY, -1);
        if (isHovered) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            graphics.blitSprite(DIRECTION_BUTTON_OVERLAY, x, y, 14, 14);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickedScrollbar;
        boolean bl = clickedScrollbar = this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, button);
        if (clickedScrollbar) {
            return true;
        }
        if (this.directions != null && this.hoveringDirectionRow != -1 && this.hoveringDirectionColumn != -2) {
            this.playClickSound();
            this.directions[this.hoveringDirectionRow] = this.hoveringDirectionColumn != -1 ? Direction.values()[this.hoveringDirectionColumn] : null;
            this.setSidedInputPatternData();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollbar != null && this.scrollbar.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollbar != null && this.scrollbar.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private int getYForScrollbarOffset(int i) {
        int scrollbarOffset = this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0;
        int scrollbarOffsetCorrected = this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18;
        return this.topPos + 5 + i * 18 - scrollbarOffsetCorrected;
    }

    private void updateScrollbarMaxOffset() {
        if (this.scrollbar == null) {
            return;
        }
        int maxFilledSlots = 0;
        int maxLastFilledSlot = 0;
        for (int i = 0; i < this.processingInputSlots.size(); ++i) {
            ResourceSlot resourceSlot = this.processingInputSlots.get(i);
            if (resourceSlot.isEmpty()) continue;
            ++maxFilledSlots;
            maxLastFilledSlot = i;
        }
        int maxOffset = Math.max(maxFilledSlots - 4, maxLastFilledSlot - 4);
        int maxOffsetCorrected = this.scrollbar.isSmoothScrolling() ? maxOffset * 18 : maxOffset;
        this.scrollbar.setMaxOffset((double)maxOffsetCorrected);
        this.scrollbar.setEnabled(maxOffsetCorrected > 0);
    }

    private ScrollbarWidget createScrollbar() {
        ScrollbarWidget s = new ScrollbarWidget(this.leftPos + 127, this.topPos + 6, ScrollbarWidget.Type.SMALL, 88);
        s.setListener(offset -> this.onScrollbarChanged((int)offset));
        return s;
    }

    private void onScrollbarChanged(int offset) {
        int scrollbarOffset = this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? offset : offset * 18;
        for (int i = 0; i < this.processingInputSlots.size(); ++i) {
            int slotY = this.topPos + 3 + 10 + i * 18 - scrollbarOffset - this.topPos;
            Platform.INSTANCE.setSlotY((Slot)this.processingInputSlots.get(i), slotY);
        }
    }

    private void setSidedInputPatternData() {
        if (this.directions == null) {
            return;
        }
        ArrayList resources = new ArrayList();
        for (ResourceSlot slot : this.processingInputSlots) {
            if (slot.getResource() != null) {
                resources.add(Optional.of(new ResourceAmount((ResourceKey)slot.getResource(), slot.getAmount())));
                continue;
            }
            resources.add(Optional.empty());
        }
        List<Optional> inputSides = Arrays.stream(this.directions).map(Optional::ofNullable).toList();
        ArrayList<Optional<SidedResourceAmount>> sidedResources = new ArrayList<Optional<SidedResourceAmount>>();
        for (int i = 0; i < resources.size(); ++i) {
            Optional resource = (Optional)resources.get(i);
            Optional direction = inputSides.get(i);
            if (resource.isPresent()) {
                sidedResources.add(Optional.of(new SidedResourceAmount((ResourceAmount)resource.get(), direction)));
                continue;
            }
            sidedResources.add(Optional.empty());
        }
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetSidedResourcesOnPatternGridBlockPacket(sidedResources));
    }

    private void renderHoveredResourceTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.tooltip == null) {
            return;
        }
        List processedLines = Platform.INSTANCE.processTooltipComponents(ItemStack.EMPTY, graphics, mouseX, Optional.empty(), this.tooltip);
        Platform.INSTANCE.renderTooltip(graphics, processedLines, mouseX, mouseY);
    }

    public void onClose() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            mc.setScreen((Screen)new PatternGridScreen(this.gridContainerMenu, mc.player.getInventory(), this.gridTitle));
        }
    }

    private void playClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static MutableComponent getDirectionName(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }
}

