/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TransferStackMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<TransferStackMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"craftingtweaks", (String)"transfer_stack"));
    private final ResourceLocation id;
    private final int slotNumber;

    public TransferStackMessage(ResourceLocation id, int slotNumber) {
        this.id = id;
        this.slotNumber = slotNumber;
    }

    public static void encode(FriendlyByteBuf buf, TransferStackMessage message) {
        buf.writeResourceLocation(message.id);
        buf.writeInt(message.slotNumber);
    }

    public static TransferStackMessage decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.readResourceLocation();
        int slotNumber = buf.readInt();
        return new TransferStackMessage(id, slotNumber);
    }

    public static void handle(ServerPlayer player, TransferStackMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.slots.size()) {
            return;
        }
        CraftingTweaksProviderManager.getCraftingGrid(menu, message.id).ifPresent(grid -> {
            Slot slot;
            GridTransferHandler<AbstractContainerMenu> transferHandler = grid.transferHandler();
            if (!transferHandler.canTransferFrom((Player)player, menu, slot = (Slot)menu.slots.get(message.slotNumber), (CraftingGrid)grid) || slot instanceof ResultSlot) {
                return;
            }
            ItemStack slotStack = slot.getItem();
            if (!slotStack.isEmpty() && slot.mayPickup((Player)player)) {
                ItemStack oldStack = slotStack.copy();
                if (!transferHandler.transferIntoGrid((CraftingGrid)grid, (Player)player, menu, slot)) {
                    return;
                }
                slot.onQuickCraft(slotStack, oldStack);
                if (slotStack.getCount() <= 0) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                if (slotStack.getCount() != oldStack.getCount()) {
                    slot.onTake((Player)player, slotStack);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

