/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.crafting;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.craftingtweaks.crafting.CraftingOperation;
import net.blay09.mods.craftingtweaks.crafting.IngredientCacheHint;
import net.blay09.mods.craftingtweaks.crafting.IngredientProvider;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CraftingContext {
    private final Map<IntList, Integer> cachedProviderIndexByIngredient = new HashMap<IntList, Integer>();
    private final Map<CraftingOperation.IngredientTokenKey, IngredientCacheHint> cacheHintsByIngredient = new HashMap<CraftingOperation.IngredientTokenKey, IngredientCacheHint>();
    private final List<IngredientProvider> ingredientProviders;

    public CraftingContext(List<IngredientProvider> ingredientProviders) {
        this.ingredientProviders = ingredientProviders;
    }

    public CraftingOperation createOperation(RecipeHolder<Recipe<?>> recipe) {
        return new CraftingOperation(this, recipe);
    }

    public List<IngredientProvider> getIngredientProviders() {
        return this.ingredientProviders;
    }

    public int getCachedIngredientProviderIndexFor(Ingredient ingredient) {
        return this.cachedProviderIndexByIngredient.getOrDefault(ingredient.getStackingIds(), -1);
    }

    public IngredientCacheHint getCacheHintFor(CraftingOperation.IngredientTokenKey ingredientTokenKey) {
        return this.cacheHintsByIngredient.getOrDefault(ingredientTokenKey, IngredientCacheHint.NONE);
    }

    public void cache(CraftingOperation.IngredientTokenKey ingredientTokenKey, int itemProviderIndex, IngredientCacheHint cacheHint) {
        this.cacheHintsByIngredient.put(ingredientTokenKey, cacheHint);
        this.cachedProviderIndexByIngredient.put(ingredientTokenKey.stackingIds(), itemProviderIndex);
    }
}

