/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.crafting;

import java.util.Collection;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.craftingtweaks.crafting.IngredientCacheHint;
import net.blay09.mods.craftingtweaks.crafting.IngredientProvider;
import net.blay09.mods.craftingtweaks.crafting.IngredientToken;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ContainerIngredientProvider
implements IngredientProvider {
    private final Container container;

    public ContainerIngredientProvider(Container container) {
        this.container = container;
    }

    @Override
    public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, IngredientCacheHint cacheHint) {
        ItemStack slotStack;
        if (cacheHint instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)cacheHint;
            slotStack = this.container.getItem(containerIngredientToken.slot);
            if (ingredient.test(slotStack) && this.hasUsesLeft(containerIngredientToken.slot, slotStack, ingredientTokens)) {
                return containerIngredientToken;
            }
        }
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            slotStack = this.container.getItem(i);
            if (!ingredient.test(slotStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ContainerIngredientToken(i);
        }
        return null;
    }

    @Override
    public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, IngredientCacheHint cacheHint) {
        ItemStack slotStack;
        if (cacheHint instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)cacheHint;
            slotStack = this.container.getItem(containerIngredientToken.slot);
            if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) && this.hasUsesLeft(containerIngredientToken.slot, slotStack, ingredientTokens)) {
                return containerIngredientToken;
            }
        }
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            slotStack = this.container.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ContainerIngredientToken(i);
        }
        return null;
    }

    protected int getUsesLeft(int slot, ItemStack slotStack, Collection<IngredientToken> ingredientTokens) {
        int usesLeft = slotStack.getCount();
        for (IngredientToken ingredientToken : ingredientTokens) {
            if (!(ingredientToken instanceof ContainerIngredientToken)) continue;
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)ingredientToken;
            if (containerIngredientToken.slot != slot) continue;
            --usesLeft;
        }
        return usesLeft;
    }

    @Override
    public IngredientCacheHint getCacheHint(IngredientToken ingredientToken) {
        IngredientCacheHint ingredientCacheHint;
        if (ingredientToken instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)ingredientToken;
            ingredientCacheHint = containerIngredientToken;
        } else {
            ingredientCacheHint = IngredientCacheHint.NONE;
        }
        return ingredientCacheHint;
    }

    private boolean hasUsesLeft(int slot, ItemStack slotStack, Collection<IngredientToken> ingredientTokens) {
        return this.getUsesLeft(slot, slotStack, ingredientTokens) > 0;
    }

    public class ContainerIngredientToken
    implements IngredientToken,
    IngredientCacheHint {
        private final int slot;
        private boolean returnRemainder;

        public ContainerIngredientToken(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack peek() {
            return ContainerIngredientProvider.this.container.getItem(this.slot);
        }

        @Override
        public ItemStack consume() {
            ItemStack consumed = ContainerUtils.extractItem((Container)ContainerIngredientProvider.this.container, (int)this.slot, (int)1, (boolean)false);
            if (this.returnRemainder) {
                ItemStack remainingItem = Balm.getHooks().getCraftingRemainingItem(consumed);
                ContainerUtils.insertItem((Container)ContainerIngredientProvider.this.container, (int)this.slot, (ItemStack)remainingItem, (boolean)false);
            }
            return consumed;
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            ItemStack restItem = ContainerUtils.insertItem((Container)ContainerIngredientProvider.this.container, (int)this.slot, (ItemStack)itemStack, (boolean)false);
            if (!restItem.isEmpty()) {
                return ContainerUtils.insertItemStacked((Container)ContainerIngredientProvider.this.container, (ItemStack)restItem, (boolean)false);
            }
            return ItemStack.EMPTY;
        }
    }
}

