/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.util;

import com.mojang.serialization.MapCodec;
import com.tristankechlo.livingthings.NeoForgeLivingThings;
import com.tristankechlo.livingthings.config.GeneralConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class LivingThingsBiomeModifier
implements BiomeModifier {
    private Map<ResourceLocation, List<MobSpawnSettings.SpawnerData>> spawnData = null;
    private static final LivingThingsBiomeModifier INSTANCE = new LivingThingsBiomeModifier();
    public static final MapCodec<LivingThingsBiomeModifier> CODEC = MapCodec.unit((Object)INSTANCE);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        Optional biomeID;
        if (this.spawnData == null) {
            this.spawnData = GeneralConfig.getSpawnData();
        }
        if ((biomeID = biome.unwrapKey()).isEmpty()) {
            return;
        }
        ResourceLocation biomeName = ((ResourceKey)biomeID.get()).location();
        if (phase == BiomeModifier.Phase.ADD && this.spawnData.containsKey(biomeName)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            List<MobSpawnSettings.SpawnerData> spawnerData = this.spawnData.get(biomeName);
            for (MobSpawnSettings.SpawnerData data : spawnerData) {
                spawns.addSpawn(data.type.getCategory(), data);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return NeoForgeLivingThings.BIOME_MODIFIER_CODEC.get();
    }
}

