/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.SharkEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SharkModel<T extends SharkEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart LeftFin;
    private final ModelPart RightFin;
    private final ModelPart Tail;
    private final ModelPart Tail2;

    public SharkModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.LeftFin = this.Body.getChild("LeftFin");
        this.RightFin = this.Body.getChild("RightFin");
        this.Tail = this.Body.getChild("Tail");
        this.Tail2 = this.Tail.getChild("Tail2");
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftFin.yRot = -0.2f * Mth.cos((float)(ageInTicks * 0.3f));
        this.RightFin.yRot = -0.2f * Mth.cos((float)(ageInTicks * 0.3f));
        this.Body.xRot = headPitch * ((float)Math.PI / 180);
        this.Body.yRot = netHeadYaw * ((float)Math.PI / 180);
        if (entityIn.getDeltaMovement().horizontalDistanceSqr() > 1.0E-7) {
            this.Body.xRot += -0.05f + -0.05f * Mth.cos((float)(ageInTicks * 0.3f));
            this.Tail.yRot = -0.15f * Mth.cos((float)(ageInTicks * 0.3f));
            this.Tail2.yRot = -0.25f * Mth.cos((float)(ageInTicks * 0.3f));
        } else {
            this.Tail.yRot = -0.05f * Mth.cos((float)(ageInTicks * 0.3f));
            this.Tail2.yRot = -0.1f * Mth.cos((float)(ageInTicks * 0.3f));
        }
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.Body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(48, 22).addBox(-6.0f, -7.0f, -18.0f, 12.0f, 14.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition TopFin = Body.addOrReplaceChild("TopFin", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -8.0f, -8.0f, 2.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition RightFin = Body.addOrReplaceChild("RightFin", CubeListBuilder.create().texOffs(0, 30).addBox(-1.0f, -2.5f, 0.0f, 1.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)4.0f, (float)-8.0f, (float)-1.0036f, (float)-0.1745f, (float)0.6981f));
        PartDefinition LeftFin = Body.addOrReplaceChild("LeftFin", CubeListBuilder.create().texOffs(0, 13).addBox(0.0f, -2.5f, 0.0f, 1.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)4.0f, (float)-8.0f, (float)-1.0036f, (float)0.1745f, (float)-0.6981f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition HeadTop = Head.addOrReplaceChild("HeadTop", CubeListBuilder.create().texOffs(78, 0).addBox(-5.5f, -3.5f, -7.0f, 11.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.5f, (float)-24.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition HeadBottom = Head.addOrReplaceChild("HeadBottom", CubeListBuilder.create().texOffs(24, 1).addBox(-5.5f, -3.6993f, -19.9537f, 11.0f, 7.0f, 12.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-9.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(30, 23).addBox(-5.0f, -6.5f, 0.0f, 10.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)10.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(0, 47).addBox(-4.0f, -5.5f, 0.0f, 8.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)11.0f));
        PartDefinition BackFinTop = Tail2.addOrReplaceChild("BackFinTop", CubeListBuilder.create().texOffs(108, 29).addBox(-1.0f, -3.4645f, -10.7071f, 2.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)15.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition BackFinBottom = Tail2.addOrReplaceChild("BackFinBottom", CubeListBuilder.create().texOffs(32, 49).addBox(-1.0f, -4.0f, -9.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)13.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

