/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.compat.jade;

import com.thevortex.allthemodium.blocks.TeleportPad;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class ATMJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation TELEPORT_PAD = ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)"teleport_pad");

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)TeleportPadComponentProvider.INSTANCE, TeleportPad.class);
    }

    private static Component getTranslation(@Nullable ResourceKey<Level> dimension) {
        MutableComponent target = dimension == null ? Component.translatable((String)String.format("dimension.%s.unknown", "allthemodium")).withStyle(ChatFormatting.RED) : Component.translatable((String)String.join((CharSequence)".", dimension.registry().getPath(), dimension.location().getNamespace(), dimension.location().getPath())).withStyle(ChatFormatting.GRAY);
        return Component.translatable((String)String.format("jade.%s.teleport_pad.transports_to", "allthemodium")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ")).withStyle(ChatFormatting.GRAY).append((Component)target);
    }

    static enum TeleportPadComponentProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            tooltip.add((Component)Component.translatable((String)String.format("jade.%s.teleport_pad.tip", "allthemodium")));
            tooltip.add(ATMJadePlugin.getTranslation(TeleportPad.getPartner((ResourceKey<Level>)accessor.getLevel().dimension(), 1)));
            if (((Boolean)accessor.getBlockState().getValue((Property)TeleportPad.SPAWNED)).booleanValue()) {
                tooltip.add((Component)Component.translatable((String)String.format("jade.%s.teleport_pad.no_drop", "allthemodium")).withStyle(ChatFormatting.RED));
            }
        }

        public ResourceLocation getUid() {
            return TELEPORT_PAD;
        }
    }
}

