/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lyrellion.ars_elemancy.common.items.armor.ArmorSet;
import lyrellion.ars_elemancy.registry.ModItems;
import lyrellion.ars_elemancy.registry.ModRegistry;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class ArsNouveauRegistry {
    public static final List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();
    public static final SpellSchool TEMPEST = new SpellSchool("tempest").withSubSchool(SpellSchools.ELEMENTAL_AIR).withSubSchool(SpellSchools.ELEMENTAL_WATER);
    public static final SpellSchool CINDER = new SpellSchool("cinder").withSubSchool(SpellSchools.ELEMENTAL_AIR).withSubSchool(SpellSchools.ELEMENTAL_FIRE);
    public static final SpellSchool SILT = new SpellSchool("silt").withSubSchool(SpellSchools.ELEMENTAL_AIR).withSubSchool(SpellSchools.ELEMENTAL_EARTH);
    public static final SpellSchool MIRE = new SpellSchool("mire").withSubSchool(SpellSchools.ELEMENTAL_EARTH).withSubSchool(SpellSchools.ELEMENTAL_WATER);
    public static final SpellSchool VAPOR = new SpellSchool("vapor").withSubSchool(SpellSchools.ELEMENTAL_FIRE).withSubSchool(SpellSchools.ELEMENTAL_WATER);
    public static final SpellSchool LAVA = new SpellSchool("lava").withSubSchool(SpellSchools.ELEMENTAL_FIRE).withSubSchool(SpellSchools.ELEMENTAL_EARTH);
    public static final SpellSchool ELEMENTAL = new SpellSchool("elemental").withSubSchool(SpellSchools.ELEMENTAL_FIRE).withSubSchool(SpellSchools.ELEMENTAL_EARTH).withSubSchool(SpellSchools.ELEMENTAL_AIR).withSubSchool(SpellSchools.ELEMENTAL_WATER);

    public static void init() {
        ArsNouveauRegistry.registerGlyphs();
        ArsNouveauRegistry.registerPerks();
        ArsNouveauRegistry.linkDamageResistances();
    }

    private static void linkDamageResistances() {
    }

    public static void registerGlyphs() {
    }

    public static void registerRitual(AbstractRitual ritual) {
        RitualRegistry.registerRitual((AbstractRitual)ritual);
    }

    public static void postInit() {
        ArsNouveauRegistry.addPerkSlots();
        ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().add((RecipeType)ModRegistry.ELEMANCY_ARMOR_UP.get());
    }

    public static void addSchool(AbstractSpellPart part, SpellSchool school) {
        part.spellSchools.add(school);
        school.addSpellPart(part);
    }

    public static void register(AbstractSpellPart spellPart) {
        GlyphRegistry.registerSpell((AbstractSpellPart)spellPart);
        registeredSpells.add(spellPart);
    }

    public static void registerPerks() {
    }

    private static void addPerkSlots() {
        ArmorSet[] medium_armors = new ArmorSet[]{ModItems.TEMPEST_ARMOR, ModItems.MIRE_ARMOR, ModItems.VAPOR_ARMOR, ModItems.CINDER_ARMOR, ModItems.LAVA_ARMOR, ModItems.SILT_ARMOR, ModItems.ELEMANCER_ARMOR};
        List<PerkSlot> perkSlots = Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE);
        for (ArmorSet set : medium_armors) {
            PerkRegistry.registerPerkProvider((ItemLike)set.getHat(), List.of(perkSlots, perkSlots, perkSlots, perkSlots));
            PerkRegistry.registerPerkProvider((ItemLike)set.getChest(), List.of(perkSlots, perkSlots, perkSlots, perkSlots));
            PerkRegistry.registerPerkProvider((ItemLike)set.getLegs(), List.of(perkSlots, perkSlots, perkSlots, perkSlots));
            PerkRegistry.registerPerkProvider((ItemLike)set.getBoots(), List.of(perkSlots, perkSlots, perkSlots, perkSlots));
        }
    }
}

