/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PowerLevelTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    private int counter = 20;

    public PowerLevelTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MonitorModule.POWER_LEVEL.be().get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerLevelTileEntity::new));
    }

    public LogicSupport getLogicSupport() {
        return this.support;
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("power", this.support.getPowerOutput());
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.support.setPowerOutput(tag.getInt("power"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.handleUpdateTag(pkt.getTag(), provider);
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 10;
        Direction inputSide = LogicSupport.getFacing((BlockState)this.level.getBlockState(this.getBlockPos())).getInputSide();
        BlockPos inputPos = this.getBlockPos().relative(inputSide);
        BlockEntity tileEntity = this.level.getBlockEntity(inputPos);
        if (!EnergyTools.isEnergyTE((BlockEntity)tileEntity, null)) {
            this.support.setRedstoneState((GenericTileEntity)this, 0);
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((BlockEntity)tileEntity, null);
        long maxEnergy = energy.maxEnergy();
        int ratio = 0;
        if (maxEnergy > 0L) {
            long stored = energy.energy();
            ratio = (int)(stored * 10L / maxEnergy);
            if (ratio < 0) {
                ratio = 0;
            } else if (ratio > 9) {
                ratio = 9;
            }
        }
        if (this.support.getPowerOutput() != ratio) {
            this.support.setRedstoneState((GenericTileEntity)this, ratio);
            this.markDirtyClient();
        }
    }
}

