/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.client;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiEndergenic
extends GenericGuiContainer<EndergenicTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private TextField lastRfPerTick;
    private TextField lastLostPearls;
    private TextField lastLaunchedPearls;
    private TextField lastOpportunities;
    private int timer = 10;

    public GuiEndergenic(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)EndergenicModule.ENDERGENIC.block().get()).getManualEntry());
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(EndergenicModule.CONTAINER_ENDERGENIC.get(), GuiEndergenic::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.getBE(), ResourceLocation.fromNamespaceAndPath((String)"rftoolspower", (String)"gui/endergenic.gui"));
        super.init();
        this.initializeFields();
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.lastRfPerTick = (TextField)this.window.findChild("lastrft");
        this.lastLostPearls = (TextField)this.window.findChild("lastlost");
        this.lastLaunchedPearls = (TextField)this.window.findChild("lastlaunched");
        this.lastOpportunities = (TextField)this.window.findChild("lastopp");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        EndergenicTileEntity tileEntity = (EndergenicTileEntity)this.getBE();
        this.energyBar.maxValue(tileEntity.getCapacity());
        this.lastRfPerTick.text(tileEntity.clientLastRfPerTick + " RF/tick");
        this.lastLostPearls.text(tileEntity.clientLastPearlsLost + " pearls");
        this.lastLaunchedPearls.text(tileEntity.clientLastPearlsLaunched + " pearls");
        this.lastOpportunities.text(tileEntity.clientLastPearlOpportunities + " times");
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.updateFields();
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
        this.checkStats();
    }

    private void checkStats() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 20;
            Networking.sendToServer((CustomPacketPayload)PacketRequestDataFromServer.create((ResourceKey)this.getBE().getDimension(), (BlockPos)this.getBE().getBlockPos(), (String)EndergenicTileEntity.CMD_GETSTATS.name(), (TypedMap)TypedMap.EMPTY, (boolean)false));
        }
        this.updateEnergyBar(this.energyBar);
    }
}

