/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.worldgen;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.unification.worldgen.WorldGenUnifier;
import com.almostreliable.unified.utils.Utils;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import org.jetbrains.annotations.Nullable;

public class WorldGenBiomeModifier
implements BiomeModifier {
    public static final MapCodec<BiomeModifier> CODEC = MapCodec.unit(WorldGenBiomeModifier::new);
    public static final ResourceLocation UNKNOWN_BIOME_ID = Utils.getRL("unknown_biome_id");
    @Nullable
    private WorldGenUnifier unifier;

    public static void bindUnifier(WorldGenBiomeModifier modifier, RegistryAccess registryAccess) {
        if (AlmostUnifiedCommon.STARTUP_CONFIG.allowWorldGenUnification()) {
            WorldGenUnifier unifier = new WorldGenUnifier(registryAccess);
            unifier.process();
            modifier.unifier = unifier;
        }
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.AFTER_EVERYTHING) {
            return;
        }
        if (this.unifier == null) {
            return;
        }
        LinkedHashMap<GenerationStep.Decoration, List> removedFeatures = new LinkedHashMap<GenerationStep.Decoration, List>();
        for (GenerationStep.Decoration dec : GenerationStep.Decoration.values()) {
            List features2 = builder.getGenerationSettings().getFeatures(dec);
            features2.removeIf(feature -> {
                if (this.unifier.shouldRemovePlacedFeature((Holder<PlacedFeature>)feature)) {
                    removedFeatures.computeIfAbsent(dec, $ -> new ArrayList()).add(feature);
                    return true;
                }
                return false;
            });
        }
        if (!removedFeatures.isEmpty()) {
            AlmostUnifiedCommon.LOGGER.info("[WorldGen] Removed features from Biome {}:", (Object)biome.unwrapKey().map(ResourceKey::location).orElse(UNKNOWN_BIOME_ID));
            removedFeatures.forEach((decoration, features) -> {
                String ids = features.stream().flatMap(f -> f.unwrapKey().map(ResourceKey::location).stream()).map(ResourceLocation::toString).collect(Collectors.joining(", "));
                AlmostUnifiedCommon.LOGGER.info("[WorldGen]\t{}: {}", (Object)decoration.getName(), (Object)ids);
            });
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

