/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateRenderer;
import com.supermartijn642.formations.tools.template.screen.TemplateEditingScreen;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TemplateEditorItem
extends BaseItem {
    public TemplateEditorItem(ItemProperties properties) {
        super(properties);
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (player.isShiftKeyDown()) {
            if (level.isClientSide) {
                if (TemplateRenderer.selectionDimension == level.dimension() && TemplateRenderer.selectionPos1 != null && TemplateRenderer.selectionPos2 != null) {
                    ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new TemplateEditingScreen(null)));
                } else {
                    player.displayClientMessage((Component)TextComponents.translation((String)"formations.template.edit.no_selection").color(ChatFormatting.RED).get(), true);
                }
            }
            return BaseItem.ItemUseResult.success((ItemStack)stack);
        }
        return super.interact(stack, player, hand, level);
    }

    public void leftClickMiss(ItemStack stack, Player player) {
        Template template = TemplateRenderer.getAimedAtTemplate();
        if (template != null) {
            ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new TemplateEditingScreen(template)));
        }
    }

    public BaseItem.InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        if (level.isClientSide) {
            if (player.isShiftKeyDown()) {
                if (TemplateRenderer.selectionDimension == level.dimension() && TemplateRenderer.selectionPos1 != null && TemplateRenderer.selectionPos2 != null) {
                    ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new TemplateEditingScreen(null)));
                } else {
                    player.displayClientMessage((Component)TextComponents.translation((String)"formations.template.edit.no_selection").color(ChatFormatting.RED).get(), true);
                }
                return BaseItem.InteractionFeedback.SUCCESS;
            }
            if (TemplateRenderer.selectionDimension != level.dimension()) {
                TemplateRenderer.selectionPos1 = null;
            }
            TemplateRenderer.selectionDimension = level.dimension();
            TemplateRenderer.selectionPos2 = hitPos;
        }
        return BaseItem.InteractionFeedback.SUCCESS;
    }

    public boolean leftClickBlock(ItemStack stack, Player player, BlockPos pos) {
        Level level = player.level();
        if (level.isClientSide) {
            if (TemplateRenderer.selectionDimension != level.dimension()) {
                TemplateRenderer.selectionPos2 = null;
            }
            TemplateRenderer.selectionDimension = level.dimension();
            TemplateRenderer.selectionPos1 = pos;
        }
        return true;
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"formations.template_editor_item.left_click_block", (Object[])new Object[]{TextComponents.fromTextComponent((Component)ClientUtils.getMinecraft().options.keyAttack.getTranslatedKeyMessage()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        info.accept((Component)TextComponents.translation((String)"formations.template_editor_item.right_click_block", (Object[])new Object[]{TextComponents.fromTextComponent((Component)ClientUtils.getMinecraft().options.keyUse.getTranslatedKeyMessage()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        info.accept((Component)TextComponents.translation((String)"formations.template_editor_item.shift_right_click", (Object[])new Object[]{TextComponents.fromTextComponent((Component)ClientUtils.getMinecraft().options.keyShift.getTranslatedKeyMessage()).color(ChatFormatting.GOLD).get(), TextComponents.fromTextComponent((Component)ClientUtils.getMinecraft().options.keyUse.getTranslatedKeyMessage()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        info.accept((Component)TextComponents.translation((String)"formations.template_editor_item.left_click", (Object[])new Object[]{TextComponents.fromTextComponent((Component)ClientUtils.getMinecraft().options.keyAttack.getTranslatedKeyMessage()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        super.appendItemInformation(stack, info, advanced);
    }
}

