/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.desk;

import com.stal111.forbidden_arcanus.common.inventory.research.ResearchDeskMenu;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;
import net.valhelsia.valhelsia_core.api.common.block.entity.neoforge.ValhelsiaContainerBlockEntity;
import org.jetbrains.annotations.NotNull;

public class ResearchDeskBlockEntity
extends ValhelsiaContainerBlockEntity<ResearchDeskBlockEntity> {
    private static final int ANIMATION_LENGTH = 1000;
    private static final IntProvider TICKS_TILL_NEXT_PAGE_FLIP = UniformInt.of((int)140, (int)280);
    private int tickCount;
    public final AnimationState stillAnimation = new AnimationState();
    public final AnimationState openingAnimation = new AnimationState();
    public final AnimationState closingAnimation = new AnimationState();
    public final AnimationState levitateAnimation = new AnimationState();
    public final AnimationState pageAnimation = new AnimationState();
    private BookState bookState = BookState.CLOSED;
    public float rot;
    public float oRot;
    public float tRot;
    private int pageFlipCounter;

    public ResearchDeskBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RESEARCH_DESK.get(), pos, state, 0);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ResearchDeskBlockEntity blockEntity) {
        Player player = level.getNearestPlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 4.0, false);
        Vec3 center = pos.getCenter();
        blockEntity.bookState = blockEntity.updateBookState(player != null);
        blockEntity.stillAnimation.animateWhen(blockEntity.bookState == BookState.CLOSED, blockEntity.tickCount);
        blockEntity.openingAnimation.animateWhen(blockEntity.bookState == BookState.OPENING, blockEntity.tickCount);
        blockEntity.closingAnimation.animateWhen(blockEntity.bookState == BookState.CLOSING, blockEntity.tickCount);
        blockEntity.levitateAnimation.animateWhen(blockEntity.bookState == BookState.OPEN, blockEntity.tickCount);
        blockEntity.pageAnimation.animateWhen(blockEntity.bookState == BookState.OPEN && blockEntity.pageFlipCounter != 0, blockEntity.tickCount);
        if (blockEntity.pageFlipCounter == 0) {
            blockEntity.pageFlipCounter = TICKS_TILL_NEXT_PAGE_FLIP.sample(level.getRandom());
        }
        --blockEntity.pageFlipCounter;
        blockEntity.oRot = blockEntity.rot;
        blockEntity.tRot = player != null ? (float)(Mth.atan2((double)(player.getZ() - center.z()), (double)(player.getX() - center.x())) + 1.5707963267948966) : blockEntity.calculateBaseRotation(state, pos);
        blockEntity.adjustRotation();
        ++blockEntity.tickCount;
    }

    @NotNull
    private BookState updateBookState(boolean playerNearby) {
        boolean currentlyChanging = this.openingAnimation.isStarted() || this.closingAnimation.isStarted();
        BookState newState = BookState.CLOSED;
        if (this.bookState == BookState.CLOSED && playerNearby && !currentlyChanging || this.bookState == BookState.OPENING && this.openingAnimation.getAccumulatedTime() < 1000L) {
            newState = BookState.OPENING;
            if (this.bookState == BookState.CLOSED && this.level != null) {
                // empty if block
            }
        } else if (this.bookState == BookState.OPENING && this.openingAnimation.getAccumulatedTime() >= 1000L || this.bookState == BookState.OPEN && playerNearby) {
            newState = BookState.OPEN;
        } else if (this.bookState == BookState.OPEN || this.bookState == BookState.CLOSING && this.closingAnimation.getAccumulatedTime() < 1000L) {
            newState = BookState.CLOSING;
            if (this.bookState != BookState.OPEN || this.level != null) {
                // empty if block
            }
        }
        return newState;
    }

    public void onLoad() {
        if (this.level != null && this.level.isClientSide()) {
            this.rot = this.calculateBaseRotation(this.getBlockState(), this.getBlockPos());
            this.stillAnimation.startIfStopped(this.tickCount);
        }
    }

    private void adjustRotation() {
        while ((double)this.rot >= Math.PI) {
            this.rot -= (float)Math.PI * 2;
        }
        while ((double)this.rot < -Math.PI) {
            this.rot += (float)Math.PI * 2;
        }
        while ((double)this.tRot >= Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while ((double)this.tRot < -Math.PI) {
            this.tRot += (float)Math.PI * 2;
        }
        float f2 = this.tRot - this.rot;
        while ((double)f2 >= Math.PI) {
            f2 -= (float)Math.PI * 2;
        }
        while ((double)f2 < -Math.PI) {
            f2 += (float)Math.PI * 2;
        }
        this.rot += f2 * 0.4f;
    }

    public float calculateBaseRotation(BlockState state, BlockPos pos) {
        Vec3 center = pos.getCenter();
        Direction direction = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise();
        Vec3 offsetPos = center.relative(direction, 1.0);
        return (float)Mth.atan2((double)(offsetPos.z() - center.z()), (double)(offsetPos.x() - center.x()));
    }

    public int getTickCount() {
        return this.tickCount;
    }

    protected Component getDefaultName() {
        return Component.empty();
    }

    protected AbstractContainerMenu createMenu(int containerId, @NotNull MenuCreationContext<ResearchDeskBlockEntity, IItemHandler> menuCreationContext) {
        return new ResearchDeskMenu(containerId, menuCreationContext);
    }

    private static enum BookState {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }
}

